/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.chunk.palette;

import java.util.function.Function;
import me.jellysquid.mods.lithium.common.world.chunk.palette.LithiumInt2ObjectBiMap;
import me.jellysquid.mods.lithium.common.world.chunk.palette.LithiumPaletteResizeListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2361;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2837;

public class LithiumHashPalette<T>
implements class_2837<T> {
    private final class_2361<T> idList;
    private final LithiumInt2ObjectBiMap<T> map;
    private final LithiumPaletteResizeListener<T> resizeHandler;
    private final Function<class_2487, T> elementDeserializer;
    private final Function<T, class_2487> elementSerializer;
    private final int indexBits;

    public LithiumHashPalette(class_2361<T> ids, int bits, LithiumPaletteResizeListener<T> resizeHandler, Function<class_2487, T> deserializer, Function<T, class_2487> serializer) {
        this.idList = ids;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        this.elementDeserializer = deserializer;
        this.elementSerializer = serializer;
        this.map = new LithiumInt2ObjectBiMap(1 << bits);
    }

    public int method_12291(T obj) {
        int id = this.map.getId(obj);
        if (id == -1 && (id = this.map.add(obj)) >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onLithiumPaletteResized(this.indexBits + 1, obj);
        }
        return id;
    }

    public boolean method_19525(T obj) {
        return this.map.containsObject(obj);
    }

    public T method_12288(int id) {
        return this.map.method_10200(id);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_12289(class_2540 buf) {
        this.map.clear();
        int entryCount = buf.method_10816();
        for (int i = 0; i < entryCount; ++i) {
            this.map.add(this.idList.method_10200(buf.method_10816()));
        }
    }

    public void method_12287(class_2540 buf) {
        int paletteBits = this.getSize();
        buf.method_10804(paletteBits);
        for (int i = 0; i < paletteBits; ++i) {
            buf.method_10804(this.idList.method_10206(this.map.method_10200(i)));
        }
    }

    public int method_12290() {
        int size = class_2540.method_10815((int)this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            size += class_2540.method_10815((int)this.idList.method_10206(this.map.method_10200(i)));
        }
        return size;
    }

    public void method_12286(class_2499 list) {
        this.map.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.map.add(this.elementDeserializer.apply(list.method_10602(i)));
        }
    }

    public void toTag(class_2499 list) {
        for (int i = 0; i < this.getSize(); ++i) {
            list.add((Object)this.elementSerializer.apply(this.map.method_10200(i)));
        }
    }

    public int getSize() {
        return this.map.size();
    }
}

