/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntry;
import me.jellysquid.mods.lithium.common.world.scheduler.TickEntryQueue;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1949;
import net.minecraft.class_1953;
import net.minecraft.class_1954;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;

public class LithiumServerTickScheduler<T>
extends class_1949<T> {
    private static final Predicate<TickEntry<?>> PREDICATE_ANY_TICK = entry -> true;
    private static final Predicate<TickEntry<?>> PREDICATE_ACTIVE_TICKS = entry -> !entry.consumed;
    private final Long2ObjectSortedMap<TickEntryQueue<T>> scheduledTicksOrdered = new Long2ObjectAVLTreeMap();
    private final Map<class_1954<T>, TickEntry<T>> scheduledTicks = new HashMap<class_1954<T>, TickEntry<T>>();
    private final ArrayList<TickEntry<T>> executingTicks = new ArrayList();
    private final Predicate<T> invalidObjPredicate;
    private final class_3218 world;
    private final Consumer<class_1954<T>> tickConsumer;

    public LithiumServerTickScheduler(class_3218 world, Predicate<T> invalidPredicate, Function<T, class_2960> idToName, Function<class_2960, T> nameToId, Consumer<class_1954<T>> consumer) {
        super(world, invalidPredicate, idToName, nameToId, consumer);
        this.invalidObjPredicate = invalidPredicate;
        this.world = world;
        this.tickConsumer = consumer;
    }

    public void method_8670() {
        this.world.method_16107().method_15396("cleaning");
        this.selectTicks(this.world.method_14178(), this.world.method_8510());
        this.world.method_16107().method_15405("executing");
        this.executeTicks(this.tickConsumer);
        this.world.method_16107().method_15407();
    }

    public boolean method_8677(class_2338 pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new class_1954(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.executing;
    }

    public boolean method_8674(class_2338 pos, T obj) {
        TickEntry<T> entry = this.scheduledTicks.get(new class_1954(pos, obj));
        if (entry == null) {
            return false;
        }
        return entry.scheduled;
    }

    public void method_20470(Stream<class_1954<T>> stream) {
        stream.forEach(this::addScheduledTick);
    }

    public List<class_1954<T>> method_8671(class_1923 chunkPos, boolean mutates, boolean getStaleTicks) {
        class_3341 box = new class_3341(chunkPos.method_8326() - 2, chunkPos.method_8328() - 2, chunkPos.method_8327() + 2, chunkPos.method_8329() + 2);
        return this.method_8672(box, mutates, getStaleTicks);
    }

    public List<class_1954<T>> method_8672(class_3341 box, boolean remove, boolean getStaleTicks) {
        Predicate<TickEntry<?>> predicate = getStaleTicks ? PREDICATE_ANY_TICK : PREDICATE_ACTIVE_TICKS;
        return remove ? this.removeTicks(box, predicate) : this.collectTicks(box, predicate);
    }

    public void method_8666(class_3341 box, class_2338 pos) {
        List<class_1954<T>> list = this.method_8672(box, false, false);
        for (class_1954<T> tick : list) {
            this.addScheduledTick(new class_1954(tick.field_9322.method_10081((class_2382)pos), tick.method_8683(), tick.field_9321, tick.field_9320));
        }
    }

    public void method_8675(class_2338 pos, T obj, int delay, class_1953 priority) {
        if (!this.invalidObjPredicate.test(obj)) {
            this.addScheduledTick(new class_1954(pos, obj, (long)delay + this.world.method_8510(), priority));
        }
    }

    public int method_20825() {
        int count = 0;
        for (TickEntry<T> entry : this.scheduledTicks.values()) {
            if (!entry.scheduled) continue;
            ++count;
        }
        return count;
    }

    public void selectTicks(class_3215 chunkManager, long time) {
        long headKey = LithiumServerTickScheduler.getBucketKey(time + 1L, class_1953.field_9315) - 1L;
        int limit = 65565;
        boolean canTick = true;
        long prevChunk = Long.MIN_VALUE;
        ObjectIterator it = this.scheduledTicksOrdered.headMap(headKey).values().iterator();
        while (limit > 0 && it.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)it.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (!tick.scheduled) continue;
                if (limit > 0) {
                    long chunk = class_1923.method_8331((int)(tick.field_9322.method_10263() >> 4), (int)(tick.field_9322.method_10260() >> 4));
                    if (prevChunk != chunk) {
                        prevChunk = chunk;
                        canTick = chunkManager.method_20529(tick.field_9322);
                    }
                    if (canTick) {
                        tick.scheduled = false;
                        tick.executing = true;
                        this.executingTicks.add(tick);
                        --limit;
                        continue;
                    }
                }
                list.setTickAtIndex(w++, tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            it.remove();
        }
    }

    public void executeTicks(Consumer<class_1954<T>> consumer) {
        for (TickEntry<T> entry : this.executingTicks) {
            try {
                entry.consumed = true;
                entry.executing = false;
                consumer.accept(entry);
                if (entry.scheduled) {
                    entry.consumed = false;
                    continue;
                }
                this.scheduledTicks.remove(entry);
            }
            catch (Throwable e) {
                class_128 crash = class_128.method_560((Throwable)e, (String)"Exception while ticking");
                class_129 section = crash.method_562("Block being ticked");
                class_129.method_586((class_129)section, (class_2338)entry.field_9322, null);
                throw new class_148(crash);
            }
        }
        this.executingTicks.clear();
    }

    private List<class_1954<T>> collectTicks(class_3341 box, Predicate<TickEntry<?>> predicate) {
        ArrayList<class_1954<T>> ret = new ArrayList<class_1954<T>>();
        for (TickEntryQueue ticks : this.scheduledTicksOrdered.values()) {
            for (int i = 0; i < ticks.size(); ++i) {
                TickEntry tick = ticks.getTickAtIndex(i);
                if (!box.method_14662((class_2382)tick.field_9322) || !predicate.test(tick)) continue;
                ret.add(tick);
            }
        }
        return ret;
    }

    private List<class_1954<T>> removeTicks(class_3341 box, Predicate<TickEntry<?>> predicate) {
        ArrayList<class_1954<T>> ret = new ArrayList<class_1954<T>>();
        ObjectIterator timeIdxIt = this.scheduledTicksOrdered.values().iterator();
        while (timeIdxIt.hasNext()) {
            TickEntryQueue list = (TickEntryQueue)timeIdxIt.next();
            int w = 0;
            for (int i = 0; i < list.size(); ++i) {
                TickEntry tick = list.getTickAtIndex(i);
                if (!box.method_14662((class_2382)tick.field_9322) || !predicate.test(tick)) {
                    list.setTickAtIndex(w++, tick);
                    continue;
                }
                tick.scheduled = false;
                ret.add(tick);
            }
            list.resize(w);
            if (!list.isEmpty()) continue;
            timeIdxIt.remove();
        }
        return ret;
    }

    private void addScheduledTick(class_1954<T> tick) {
        TickEntry entry = this.scheduledTicks.computeIfAbsent(tick, TickEntry::new);
        if (!entry.scheduled) {
            TickEntryQueue timeIdx = (TickEntryQueue)this.scheduledTicksOrdered.computeIfAbsent(LithiumServerTickScheduler.getBucketKey(tick.field_9321, tick.field_9320), key -> new TickEntryQueue());
            timeIdx.push(entry);
            entry.scheduled = true;
        }
    }

    private static long getBucketKey(long time, class_1953 priority) {
        return time << 4 | (long)(priority.ordinal() & 0xF);
    }
}

