/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.fast_goal_selection;

import java.util.Set;
import me.jellysquid.mods.lithium.common.ai.ExtendedGoal;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_3695;
import net.minecraft.class_4135;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1355.class})
public abstract class MixinGoalSelector {
    @Shadow
    @Final
    private class_3695 field_6463;
    @Mutable
    @Shadow
    @Final
    private Set<class_4135> field_6461;
    private boolean[] disabledControlsArray;
    private class_4135[] goalsByControlArray;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_3695 profiler, CallbackInfo ci) {
        this.disabledControlsArray = new boolean[4];
        this.goalsByControlArray = new class_4135[4];
    }

    @Overwrite
    public void method_6275() {
        this.updateGoalStates();
        this.tickGoals();
    }

    private void updateGoalStates() {
        this.field_6463.method_15396("goalUpdate");
        this.stopGoals();
        this.cleanupControls();
        this.startGoals();
        this.field_6463.method_15407();
    }

    private void stopGoals() {
        for (class_4135 goal : this.field_6461) {
            if (!goal.method_19056() || goal.method_6266() && !this.areControlsDisabled(goal)) continue;
            goal.method_6270();
        }
    }

    private void cleanupControls() {
        for (int i = 0; i < this.goalsByControlArray.length; ++i) {
            class_4135 goal = this.goalsByControlArray[i];
            if (goal == null || goal.method_19056()) continue;
            this.goalsByControlArray[i] = null;
        }
    }

    private void startGoals() {
        for (class_4135 goal : this.field_6461) {
            if (goal.method_19056() || !goal.method_6264() || !this.areGoalControlsAvailable(goal)) continue;
            for (class_1352.class_4134 control : MixinGoalSelector.getControls(goal)) {
                class_4135 otherGoal = this.getGoalOccupyingControl(control);
                if (otherGoal != null) {
                    otherGoal.method_6270();
                }
                this.setGoalOccupyingControl(control, goal);
            }
            goal.method_6269();
        }
    }

    private void tickGoals() {
        this.field_6463.method_15396("goalTick");
        for (class_4135 goal : this.field_6461) {
            if (!goal.method_19056()) continue;
            goal.method_6268();
        }
        this.field_6463.method_15407();
    }

    private boolean areControlsDisabled(class_4135 goal) {
        for (class_1352.class_4134 control : MixinGoalSelector.getControls(goal)) {
            if (!this.isControlDisabled(control)) continue;
            return true;
        }
        return false;
    }

    private boolean areGoalControlsAvailable(class_4135 goal) {
        for (class_1352.class_4134 control : MixinGoalSelector.getControls(goal)) {
            if (this.isControlDisabled(control)) {
                return false;
            }
            class_4135 occupied = this.getGoalOccupyingControl(control);
            if (occupied == null || occupied.method_19055(goal)) continue;
            return false;
        }
        return true;
    }

    @Overwrite
    public void method_6274(class_1352.class_4134 control) {
        this.disabledControlsArray[control.ordinal()] = true;
    }

    @Overwrite
    public void method_6273(class_1352.class_4134 control) {
        this.disabledControlsArray[control.ordinal()] = false;
    }

    private boolean isControlDisabled(class_1352.class_4134 control) {
        return this.disabledControlsArray[control.ordinal()];
    }

    private class_4135 getGoalOccupyingControl(class_1352.class_4134 control) {
        return this.goalsByControlArray[control.ordinal()];
    }

    private void setGoalOccupyingControl(class_1352.class_4134 control, class_4135 goal) {
        this.goalsByControlArray[control.ordinal()] = goal;
    }

    private static class_1352.class_4134[] getControls(class_4135 goal) {
        return ((ExtendedGoal)goal.method_19058()).getRequiredControls();
    }
}

