/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.client.fast_loading_screen;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.IdentityHashMap;
import me.jellysquid.mods.lithium.common.util.math.Color4;
import net.minecraft.class_2806;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_3928;
import net.minecraft.class_3953;
import net.minecraft.class_4493;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_3928.class})
public class MixinLevelLoadingScreen {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<class_2806> field_17407;
    private static IdentityHashMap<class_2806, Color4> STATUS_TO_COLOR_FAST;
    private static final Color4 NULL_STATUS_COLOR;
    private static final Color4 DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void method_17538(class_3953 tracker, int mapX, int mapY, int mapScale, int mapPadding) {
        if (STATUS_TO_COLOR_FAST == null) {
            STATUS_TO_COLOR_FAST = new IdentityHashMap(field_17407.size());
            STATUS_TO_COLOR_FAST.put(null, NULL_STATUS_COLOR);
            field_17407.object2IntEntrySet().forEach(entry -> STATUS_TO_COLOR_FAST.put((class_2806)entry.getKey(), Color4.fromRGBA(entry.getIntValue() | 0xFF000000)));
        }
        class_289 tessellator = class_289.method_1348();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(7, class_290.field_1576);
        int centerSize = tracker.method_17677();
        int size = tracker.method_17678();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            MixinLevelLoadingScreen.addRect(buffer, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(buffer, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(buffer, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(buffer, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        class_2806 prevStatus = null;
        Color4 prevColor = NULL_STATUS_COLOR;
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                Color4 color;
                int tileY = mapStartY + z * tileSize;
                class_2806 status = tracker.method_17676(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = STATUS_TO_COLOR_FAST.get(status);
                    prevStatus = status;
                    prevColor = color;
                }
                MixinLevelLoadingScreen.addRect(buffer, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
        tessellator.method_1350();
        class_4493.method_21910();
        class_4493.method_22053();
    }

    private static void addRect(class_287 buffer, double x1, double y1, double x2, double y2, Color4 color) {
        buffer.method_22912(x1, y2, 0.0).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x2, y2, 0.0).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x2, y1, 0.0).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x1, y1, 0.0).method_1336(color.r, color.g, color.b, color.a).method_1344();
    }

    static {
        NULL_STATUS_COLOR = Color4.fromRGBA(-16777216);
        DEFAULT_STATUS_COLOR = Color4.fromRGBA(-16772609);
    }
}

