/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm.consumers;

import java.util.List;
import java.util.function.Consumer;
import me.jellysquid.mods.lithium.asm.ASMUtil;
import org.objectweb.asm.tree.ClassNode;

public class PatchSetTransformer
implements Consumer<ClassNode> {
    private final String patchName;
    private final List<Consumer<ClassNode>> transformers;

    public PatchSetTransformer(String patchName, List<Consumer<ClassNode>> transformers) {
        this.patchName = patchName;
        this.transformers = transformers;
    }

    @Override
    public void accept(ClassNode classNode) {
        ASMUtil.LOGGER.info("Transforming class {} using patch set '{}'", (Object)classNode.name, (Object)this.patchName);
        for (Consumer<ClassNode> transformer : this.transformers) {
            transformer.accept(classNode);
        }
    }
}

