/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import melonslise.locks.Locks;
import melonslise.locks.common.network.PacketCheckPin;
import melonslise.locks.common.network.PacketLockSuccess;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUILockpicking
extends GuiScreen {
    private int tilePosX;
    private int tilePosY;
    private int tilePosZ;
    private int lockLength;
    private boolean[] isPinMoved;
    private int pinNumber;
    private int pinOrder;
    private static final ResourceLocation texture = new ResourceLocation("locks:textures/gui/Lockpicking.png");
    private int imageWidth;
    private int imageHeight;
    private int spriteLockpickX;
    private int spriteLockpickMotion;
    private int spriteLockpickRotation;
    private int spriteLockpickRotationMotion;
    private boolean isSpriteLockpickRotating;
    private int[] spritePinY;
    private int[] spritePinMotion;
    private boolean[] isSpritePinCorrect;
    private boolean[] isSpritePinMoving;

    public GUILockpicking(int posX, int posY, int posZ, int lockLength) {
        this.tilePosX = posX;
        this.tilePosY = posY;
        this.tilePosZ = posZ;
        this.lockLength = lockLength;
        this.isPinMoved = new boolean[lockLength];
        this.imageWidth = 12 + lockLength * 24 + 12;
        this.imageHeight = 64;
        this.spritePinY = new int[lockLength];
        this.spritePinMotion = new int[lockLength];
        this.isSpritePinCorrect = new boolean[lockLength];
        this.isSpritePinMoving = new boolean[lockLength];
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int cornerX = (this.field_146294_l - this.imageWidth) / 2;
        int cornerY = (this.field_146295_m - this.imageHeight) / 2;
        for (int j = 0; j < this.lockLength + 1; ++j) {
            this.func_73729_b(cornerX + j * 24, cornerY - 48, 24, 0, 24, 120);
        }
        for (i = 0; i < this.lockLength; ++i) {
            this.func_73729_b(cornerX + i * 24 + 12, cornerY, 0, 0, 24, 64);
        }
        this.func_73729_b(cornerX + this.lockLength * 24 + 12, cornerY, 0, 0, 12, 64);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(cornerX - 78 + this.spriteLockpickX), (float)(cornerY + 24), (float)0.0f);
        GL11.glRotatef((float)this.spriteLockpickRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(-78, 0, 60, 0, 192, 24);
        GL11.glPopMatrix();
        for (i = 0; i < this.lockLength; ++i) {
            this.func_73729_b(cornerX + i * 24 + 18, cornerY - 48, 48, 48, 12, 24);
        }
        for (i = 0; i < this.lockLength; ++i) {
            this.func_73729_b(cornerX + i * 24 + 18, cornerY + this.spritePinY[i] - 24, 48, 0, 12, 48);
        }
        this.func_73729_b(cornerX, cornerY, 0, 0, 12, 64);
        this.field_146289_q.func_78276_b(EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking1", (Object[])new Object[0]), 5, 5, 0);
        if (this.isAllTrue(this.isPinMoved)) {
            this.func_73732_a(this.field_146289_q, EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking2", (Object[])new Object[0]), this.field_146294_l / 2, cornerY - 75, 0);
            this.func_73732_a(this.field_146289_q, EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking3", (Object[])new Object[0]), this.field_146294_l / 2, cornerY - 65, 0);
        } else {
            this.func_73732_a(this.field_146289_q, EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking4", (Object[])new Object[0]), this.field_146294_l / 2, cornerY + 80, 0);
            this.func_73732_a(this.field_146289_q, EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking5", (Object[])new Object[0]), this.field_146294_l / 2, cornerY + 90, 0);
            this.func_73732_a(this.field_146289_q, EnumChatFormatting.WHITE + I18n.func_135052_a((String)"gui.lockpicking6", (Object[])new Object[0]), this.field_146294_l / 2, cornerY + 100, 0);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (int i = 0; i < this.lockLength; ++i) {
            if (this.isSpritePinCorrect[i]) {
                if (this.spritePinMotion[i] <= 0) continue;
                this.spritePinY[i] = this.spritePinY[i] - 4;
                this.spritePinMotion[i] = this.spritePinMotion[i] - 1;
                continue;
            }
            if (this.spritePinMotion[i] == 0) {
                this.isSpritePinMoving[i] = false;
            }
            if (this.spritePinMotion[i] > 3) {
                this.spritePinY[i] = this.spritePinY[i] - 6;
                this.spritePinMotion[i] = this.spritePinMotion[i] - 1;
                continue;
            }
            if (this.spritePinMotion[i] <= 0) continue;
            this.spritePinY[i] = this.spritePinY[i] + 6;
            this.spritePinMotion[i] = this.spritePinMotion[i] - 1;
        }
        if (this.spriteLockpickMotion < 0) {
            this.spriteLockpickX -= 4;
            ++this.spriteLockpickMotion;
        } else if (this.spriteLockpickMotion > 0) {
            this.spriteLockpickX += 4;
            --this.spriteLockpickMotion;
        }
        if (this.spriteLockpickRotationMotion == 0) {
            this.isSpriteLockpickRotating = false;
        }
        if (this.spriteLockpickRotationMotion > 5) {
            --this.spriteLockpickRotation;
            --this.spriteLockpickRotationMotion;
        } else if (this.spriteLockpickRotationMotion > 0) {
            ++this.spriteLockpickRotation;
            --this.spriteLockpickRotationMotion;
        }
    }

    public void func_73866_w_() {
    }

    protected void func_73869_a(char character, int id) {
        super.func_73869_a(character, id);
        if (id == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i() || id == 203) {
            if (this.pinNumber - 1 >= 0) {
                --this.pinNumber;
                this.moveLockpickSprite(-6);
            }
        } else if (id == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i() || id == 205) {
            if (this.pinNumber + 1 <= this.lockLength - 1) {
                ++this.pinNumber;
                this.moveLockpickSprite(6);
            }
        } else if (id == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || id == 200) {
            if (!this.isPinMoved[this.pinNumber] && !this.isAllTrue(this.isPinMoved)) {
                if (!this.isSpriteLockpickRotating) {
                    this.rotateLockpickSprite(10);
                }
                Locks.network.sendToServer((IMessage)new PacketCheckPin(this.tilePosX, this.tilePosY, this.tilePosZ, this.pinNumber, this.pinOrder));
            }
        } else if (id == 28 && this.isAllTrue(this.isPinMoved)) {
            Locks.network.sendToServer((IMessage)new PacketLockSuccess(this.tilePosX, this.tilePosY, this.tilePosZ));
            this.closeGUI();
        }
    }

    private boolean isAllTrue(boolean[] array1) {
        for (boolean array2 : array1) {
            if (array2) continue;
            return false;
        }
        return true;
    }

    private void moveLockpickSprite(int motion) {
        this.spriteLockpickMotion += motion;
    }

    private void rotateLockpickSprite(int rotation) {
        this.spriteLockpickRotationMotion = rotation;
        this.isSpriteLockpickRotating = true;
    }

    private void movePinSprite(int pin, int motion, boolean isCorrect) {
        this.spritePinMotion[pin] = motion;
        if (isCorrect) {
            this.isSpritePinCorrect[pin] = true;
        } else {
            this.isSpritePinCorrect[pin] = false;
            this.isSpritePinMoving[pin] = true;
        }
    }

    public void handlePinMatch(boolean isSuccessful, int pinNumber) {
        if (isSuccessful) {
            this.pinMatch(pinNumber);
        } else {
            this.pinFail(pinNumber);
        }
    }

    private void pinMatch(int pinNumber) {
        this.isPinMoved[pinNumber] = true;
        ++this.pinOrder;
        this.movePinSprite(pinNumber, 6, true);
    }

    private void pinFail(int pinNumber) {
        if (!this.isSpritePinMoving[pinNumber]) {
            this.movePinSprite(pinNumber, 6, false);
        }
    }

    public void closeGUI() {
        this.resetGUI();
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
    }

    public void resetGUI() {
        this.pinOrder = 0;
        this.pinNumber = 0;
        this.spriteLockpickMotion = 0;
        this.spriteLockpickX = 0;
        this.spriteLockpickRotation = 0;
        this.spriteLockpickRotationMotion = 0;
        for (int j = 0; j < this.isPinMoved.length; ++j) {
            this.isPinMoved[j] = false;
            this.isSpritePinCorrect[j] = false;
            this.spritePinMotion[j] = 0;
            this.spritePinY[j] = 0;
            this.isSpritePinMoving[j] = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

