/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import melonslise.locks.Locks;
import melonslise.locks.common.tileentity.TileEntityLockableContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityLockableBase
extends TileEntity {
    private Random random = new Random();
    private int[] lockPins;

    public TileEntityLockableBase() {
    }

    public TileEntityLockableBase(int lockLength) {
        this.lockPins = new int[lockLength];
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af() && player.func_70694_bm() != null) {
                if (player.func_70694_bm().func_77973_b() == Locks.itemLockpick) {
                    this.generatePattern(world);
                    return true;
                }
                if (player.func_70694_bm().func_77973_b() == Locks.itemMasterKey) {
                    this.handleOpenLock(player);
                    return true;
                }
            }
        } else if (!player.func_70093_af() && player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() == Locks.itemLockpick) {
                player.openGui((Object)Locks.instance, 0, world, x, y, z);
                return true;
            }
            if (player.func_70694_bm().func_77973_b() == Locks.itemMasterKey) {
                return true;
            }
        }
        return true;
    }

    public void generatePattern(World world) {
        if (!world.field_72995_K) {
            ArrayList<Integer> lockPins = new ArrayList<Integer>();
            lockPins.clear();
            for (int i = 0; i < this.lockPins.length; ++i) {
                lockPins.add(i);
                Collections.shuffle(lockPins);
            }
            Collections.shuffle(lockPins);
            for (int k = 0; k < lockPins.size(); ++k) {
                this.lockPins[k] = (Integer)lockPins.get(k);
            }
        }
    }

    public void handleOpenLock(EntityPlayer player) {
        TileEntity tileEntity = player.field_70170_p.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (tileEntity instanceof TileEntityLockableContainer) {
            this.openLock(player, (IInventory)this);
        } else {
            this.openLock(player, null);
        }
    }

    public void openLock(EntityPlayer player, IInventory inventory) {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "locks:LockOpen", 1.0f, 0.9f + this.random.nextFloat() * 0.15f);
    }

    public int getLockLength() {
        return this.lockPins.length;
    }

    public int getLockPin(int queueNumber) {
        return this.lockPins[queueNumber];
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.lockPins = new int[nbtTagCompound.func_74765_d("LockLength")];
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("LockLength", (short)this.lockPins.length);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

