/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.tileentity;

import java.util.List;
import melonslise.locks.common.block.BlockLockableContainer;
import melonslise.locks.common.tileentity.TileEntityLockableBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityLockableContainer
extends TileEntityLockableBase
implements IInventory {
    private ItemStack[] inventory;
    private String customName;
    private String defaultName;
    private int playersUsing;
    public float lidAngle;
    public float prevLidAngle;
    private int ticksSinceSync;

    public TileEntityLockableContainer() {
    }

    public TileEntityLockableContainer(int inventorySize, String defaultName, int lockLength) {
        super(lockLength);
        this.inventory = new ItemStack[inventorySize];
        this.defaultName = defaultName;
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (this.playersUsing <= 1) {
            return super.onBlockActivated(world, x, y, z, player, side);
        }
        return false;
    }

    @Override
    public void openLock(EntityPlayer player, IInventory inventory) {
        super.openLock(player, inventory);
        if (!player.field_70170_p.field_72995_K) {
            player.func_71007_a(inventory);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        if (this.func_145818_k_()) {
            return this.customName;
        }
        return this.defaultName;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagList nbttaglist = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[nbtTagCompound.func_74765_d("InventorySize")];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b = nbttagcompound1.func_74771_c("Slot");
            if (b < 0 || b >= this.inventory.length) continue;
            this.inventory[b] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.defaultName = nbtTagCompound.func_74779_i("DefaultName");
        if (nbtTagCompound.func_150297_b("CustomName", 8)) {
            this.customName = nbtTagCompound.func_74779_i("CustomName");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        nbtTagCompound.func_74777_a("InventorySize", (short)this.inventory.length);
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbtTagCompound.func_74778_a("DefaultName", this.defaultName);
        if (this.func_145818_k_()) {
            nbtTagCompound.func_74778_a("CustomName", this.customName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
        if (this.playersUsing < 0) {
            this.playersUsing = 0;
        }
        ++this.playersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.playersUsing);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.func_145838_q() instanceof BlockLockableContainer) {
            --this.playersUsing;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.playersUsing);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    public void func_145845_h() {
        float f;
        super.func_145845_h();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.playersUsing != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.playersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this) continue;
                ++this.playersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d2 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d0 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.playersUsing = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }
}

