/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import melonslise.locks.common.capability.LocksCapabilities;
import melonslise.locks.common.config.LocksConfiguration;
import melonslise.locks.common.item.LocksItems;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import melonslise.locks.utility.LocksUtilities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="locks", value={Side.CLIENT})
public class LocksClientEvents {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        LocksItems.registerModels(event);
    }

    public static boolean intersectsInclusive(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.field_72340_a <= box2.field_72336_d && box1.field_72336_d >= box2.field_72340_a && box1.field_72338_b <= box2.field_72337_e && box1.field_72337_e >= box2.field_72338_b && box1.field_72339_c <= box2.field_72334_f && box1.field_72334_f >= box2.field_72339_c;
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        BlockPos position1;
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d origin = LocksUtilities.getRenderOrigin(event.getPartialTicks());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-origin.field_72450_a), (double)(-origin.field_72448_b), (double)(-origin.field_72449_c));
        for (Lockable lockable : StorageLockables.get((World)mc.field_71441_e).getLockables()) {
            boolean open = true;
            ArrayList boxes = Lists.newArrayList();
            for (BlockPos.MutableBlockPos position : BlockPos.func_191531_b((int)lockable.box.x1, (int)lockable.box.y1, (int)lockable.box.z1, (int)(lockable.box.x2 - 1), (int)(lockable.box.y2 - 1), (int)(lockable.box.z2 - 1))) {
                AxisAlignedBB box = mc.field_71441_e.func_180495_p((BlockPos)position).func_185890_d((IBlockAccess)mc.field_71441_e, (BlockPos)position);
                if (box == null || box == Block.field_185506_k) continue;
                AxisAlignedBB union = box = box.func_186670_a((BlockPos)position);
                Iterator iterator = boxes.iterator();
                while (iterator.hasNext()) {
                    AxisAlignedBB box1 = (AxisAlignedBB)iterator.next();
                    if (!LocksClientEvents.intersectsInclusive(union, box1)) continue;
                    union = union.func_111270_a(box1);
                    iterator.remove();
                }
                boxes.add(union);
            }
            if (boxes.isEmpty()) continue;
            Vec3d center = LocksUtilities.getBoxSideCenter(lockable.box, lockable.side);
            EnumFacing side = lockable.side;
            Vec3d point = center;
            double distanceMinimum = -1.0;
            for (AxisAlignedBB box : boxes) {
                for (EnumFacing side1 : EnumFacing.field_82609_l) {
                    Vec3d point1 = LocksUtilities.getBoxSideCenter(box, side1).func_178787_e(new Vec3d(side1.func_176730_m()).func_186678_a(0.05));
                    double distance = center.func_72436_e(point1);
                    if (distanceMinimum != -1.0 && distance >= distanceMinimum) continue;
                    point = point1;
                    distanceMinimum = distance;
                    side = side1;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)point.field_72450_a, (double)point.field_72448_b, (double)point.field_72449_c);
            GlStateManager.func_179114_b((float)lockable.side.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
            if (lockable.side == EnumFacing.UP) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (lockable.side == EnumFacing.DOWN) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            mc.field_71460_t.func_180436_i();
            mc.func_175599_af().func_181564_a(new ItemStack(LocksItems.lock), ItemCameraTransforms.TransformType.FIXED);
            mc.field_71460_t.func_175072_h();
            GlStateManager.func_179121_F();
        }
        if (LocksConfiguration.client.enable_cui && (position1 = LocksCapabilities.getLockBounds((EntityPlayer)mc.field_71439_g).get()) != null) {
            BlockPos position2 = mc.field_71476_x.func_178782_a() != null ? mc.field_71476_x.func_178782_a() : position1;
            Box box = new Box(position1, position2);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            RenderGlobal.func_189694_a((double)box.x1, (double)box.y1, (double)box.z1, (double)box.x2, (double)box.y2, (double)box.z2, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
    }
}

