/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import java.io.IOException;
import melonslise.locks.client.gui.api.sprite.Texture;
import melonslise.locks.client.gui.sprite.SpriteLockPick;
import melonslise.locks.client.gui.sprite.SpritePin;
import melonslise.locks.common.container.ContainerLockPicking;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.server.MessageCheckPin;
import melonslise.locks.utility.LocksUtilities;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiLockPicking
extends GuiContainer {
    protected int length;
    public static final ResourceLocation textures = new ResourceLocation("locks", "textures/gui/lockpicking.png");
    public static final String title = LocksUtilities.prefixLocks("gui.lockpicking.title");
    public static final String hint = LocksUtilities.prefixLocks("gui.lockpicking.open");
    protected int textureWidth;
    protected int textureHeight;
    protected Texture outerLock = new Texture(24, 0, 24, 120);
    protected Texture innerLock = new Texture(0, 0, 24, 64);
    protected Texture spring = new Texture(48, 48, 12, 24);
    protected Texture edge = new Texture(0, 0, 12, 64);
    protected Texture pin = new Texture(48, 0, 12, 48);
    protected SpriteLockPick lockPick = new SpriteLockPick(new Texture(60, 0, 192, 24));
    protected SpritePin[] pins;
    protected int currentPin;

    public GuiLockPicking(ContainerLockPicking container) {
        super((Container)container);
        this.setLength(container.lockable.lock.getLength());
    }

    public void setLength(int length) {
        this.length = length;
        this.textureWidth = 12 + this.length * 24 + 12;
        this.textureHeight = 64;
        this.pins = new SpritePin[length];
        for (int a = 0; a < this.pins.length; ++a) {
            this.pins[a] = new SpritePin(this.pin);
        }
    }

    public void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int a;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textures);
        int cornerX = (this.field_146294_l - this.textureWidth) / 2;
        int cornerY = (this.field_146295_m - this.textureHeight) / 2;
        for (a = 0; a < this.length + 1; ++a) {
            this.outerLock.draw((Gui)this, cornerX + a * 24, cornerY - 48);
        }
        for (a = 0; a < this.length; ++a) {
            this.innerLock.draw((Gui)this, cornerX + a * 24 + 12, cornerY);
        }
        this.edge.draw((Gui)this, cornerX + this.length * 24 + 12, cornerY);
        this.lockPick.draw((Gui)this, cornerX - 156, cornerY + 24, partialTick);
        for (a = 0; a < this.pins.length; ++a) {
            this.spring.draw((Gui)this, cornerX + a * 24 + 18, cornerY - 48);
            this.pins[a].draw((Gui)this, cornerX + a * 24 + 18, cornerY - 24, partialTick);
        }
        this.edge.draw((Gui)this, cornerX, cornerY);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)title, (Object[])new Object[0]), this.field_146294_l / 2, 10, 0xFFFFFF);
        if (this.isOpen()) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)hint, (Object[])new Object[0]), this.field_146294_l / 2, cornerY + 96, 0xFFFFFF);
        }
    }

    public boolean isOpen() {
        for (SpritePin pin : this.pins) {
            if (pin.isPulled) continue;
            return false;
        }
        return true;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.lockPick.update();
        this.boundLockPick();
        for (int a = 0; a < this.length; ++a) {
            this.pins[a].update();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        char key = Keyboard.getEventCharacter();
        int code = Keyboard.getEventKey();
        if (Keyboard.getEventKeyState()) {
            this.keyPressed(key, code);
        } else {
            this.keyReleased(key, code);
        }
    }

    protected void keyPressed(char key, int code) {
        if (code == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.lockPick.motionX = -4.0f;
        } else if (code == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.lockPick.motionX = 4.0f;
        } else if (code == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() && this.lockPick.rotation == 0.0f) {
            this.rotateLockPick(-6);
            this.pullPin(this.getSelectedPin());
        }
    }

    protected void keyReleased(char key, int code) {
        if (code == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.lockPick.motionX = 0.0f;
        }
        if (code == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.lockPick.motionX = 0.0f;
        }
    }

    protected void boundLockPick() {
        this.lockPick.shiftX = MathHelper.func_76131_a((float)this.lockPick.shiftX, (float)0.0f, (float)((this.length - 1) * 24));
    }

    protected void rotateLockPick(int degrees) {
        int motion = 2 * Integer.signum(degrees);
        this.lockPick.rotate(motion, degrees / motion);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.shiftX + 12.0f) / 24.0f);
    }

    protected void pullPin(int pin) {
        if (this.pins[pin].isPulled) {
            return;
        }
        this.currentPin = pin;
        LocksNetworks.network.sendToServer((IMessage)new MessageCheckPin(pin));
    }

    public void handlePin(boolean correct) {
        this.pins[this.currentPin].moveY(-8.0f, 3);
        if (!correct) {
            return;
        }
        this.pins[this.currentPin].isPulled = true;
    }

    public void reset() {
        this.lockPick.reset();
        for (SpritePin pin : this.pins) {
            pin.isPulled = false;
        }
    }
}

