/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui.api.sprite;

import melonslise.locks.client.gui.api.sprite.Texture;
import net.minecraft.client.gui.Gui;

public class Sprite {
    public Texture texture;
    public float shiftX;
    public float shiftY;
    public float oldShiftX;
    public float oldShiftY;
    public float motionX;
    public float motionY;
    public int ticksX;
    public int ticksY;

    public Sprite(Texture texture) {
        this.texture = texture;
    }

    public void draw(Gui gui, float positionX, float positionY, float partialTick) {
        this.texture.draw(gui, positionX + this.oldShiftX + (this.shiftX - this.oldShiftX) * partialTick, positionY + this.oldShiftY + (this.shiftY - this.oldShiftY) * partialTick);
    }

    public void update() {
        this.moveX();
        this.moveY();
    }

    protected void moveX() {
        this.oldShiftX = this.shiftX;
        if (this.ticksX > 0) {
            this.shiftX += this.motionX;
            --this.ticksX;
            if (this.ticksX <= 0) {
                this.motionX = 0.0f;
            }
        } else {
            this.shiftX += this.motionX;
        }
    }

    protected void moveY() {
        this.oldShiftY = this.shiftY;
        if (this.ticksY > 0) {
            this.shiftY += this.motionY;
            --this.ticksY;
            if (this.ticksY <= 0) {
                this.motionY = 0.0f;
            }
        } else {
            this.shiftY += this.motionY;
        }
    }

    public void moveX(float motion, int ticks) {
        this.motionX = motion;
        this.ticksX = ticks;
    }

    public void moveY(float motion, int ticks) {
        this.motionY = motion;
        this.ticksY = ticks;
    }

    public void reset() {
        this.motionY = 0.0f;
        this.motionX = 0.0f;
        this.oldShiftY = 0.0f;
        this.oldShiftX = 0.0f;
        this.shiftY = 0.0f;
        this.shiftX = 0.0f;
        this.ticksY = 0;
        this.ticksX = 0;
    }
}

