/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.Iterator;
import melonslise.locks.common.item.ItemLockPick;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.client.MessageCheckPinResult;
import melonslise.locks.common.sound.LocksSounds;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerLockPicking
extends Container {
    public final EntityPlayer player;
    public final BlockPos position;
    public final Lockable lockable;
    protected int currentIndex = 0;
    protected boolean open;

    public ContainerLockPicking(EntityPlayer player, BlockPos position, Lockable lockable) {
        this.player = player;
        this.position = position;
        this.lockable = lockable;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (player.func_174831_c(this.position) > 9.0) {
            return false;
        }
        Iterator iterator = player.field_71069_bz.func_75138_a().iterator();
        while (iterator.hasNext()) {
            if (!(((ItemStack)iterator.next()).func_77973_b() instanceof ItemLockPick)) continue;
            return true;
        }
        return false;
    }

    public void checkPin(int currentPin) {
        if (this.open || this.player.field_70170_p.field_72995_K) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currentIndex, currentPin)) {
            ++this.currentIndex;
            if (this.currentIndex == this.lockable.lock.getLength()) {
                this.open = true;
            }
            correct = true;
            this.player.field_70170_p.func_184133_a(null, this.position, (SoundEvent)LocksSounds.pin_match, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            if (this.breakPick(this.player)) {
                reset = true;
                this.reset();
            }
            this.player.field_70170_p.func_184133_a(null, this.position, (SoundEvent)LocksSounds.pin_fail, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        LocksNetworks.network.sendTo((IMessage)new MessageCheckPinResult(correct, reset), (EntityPlayerMP)this.player);
    }

    protected void reset() {
        this.currentIndex = 0;
    }

    protected boolean breakPick(EntityPlayer player) {
        for (ItemStack stack : player.field_71069_bz.func_75138_a()) {
            if (!(stack.func_77973_b() instanceof ItemLockPick)) continue;
            if (ThreadLocalRandom.current().nextFloat() <= ((ItemLockPick)stack.func_77973_b()).getStrength(player.field_70170_p)) {
                return false;
            }
            this.player.func_70669_a(stack);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (player.field_70170_p.field_72995_K || !this.open || !this.lockable.lock.isLocked()) {
            return;
        }
        StorageLockables.get(player.field_70170_p).toggle(this.lockable.box);
        this.player.field_70170_p.func_184133_a(null, this.position, (SoundEvent)LocksSounds.lock_open, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

