/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.Map;
import java.util.UUID;
import melonslise.locks.common.capability.LocksCapabilities;
import melonslise.locks.common.capability.entity.ICapabilityLockBounds;
import melonslise.locks.common.config.LocksConfiguration;
import melonslise.locks.common.item.ItemLock;
import melonslise.locks.common.item.LocksItems;
import melonslise.locks.common.item.api.lockable.ItemLockable;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.client.MessageConfiguration;
import melonslise.locks.common.sound.LocksSounds;
import melonslise.locks.common.world.ListenerLockables;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lock;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import melonslise.locks.utility.LocksUtilities;
import melonslise.locks.utility.predicate.LocksSelectors;
import melonslise.locks.utility.predicate.PredicateIntersecting;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="locks")
public class LocksEvents {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        LocksItems.register(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        LocksSounds.register(event);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent event) {
        LocksCapabilities.attach(event);
    }

    @SubscribeEvent
    public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        StorageLockables.get(event.player.field_70170_p).synchronize();
        LocksConfiguration.synchronize((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        StorageLockables.get(event.player.field_70170_p).synchronize();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        StorageLockables.get(event.player.field_70170_p).synchronize();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new ListenerLockables());
    }

    @SubscribeEvent
    public static void onChunkPopulate(PopulateChunkEvent.Post event) {
        World world = event.getWorld();
        if (!LocksConfiguration.getMain((World)world).generate_locks) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (Map.Entry entry : world.func_72964_e(event.getChunkX(), event.getChunkZ()).func_177434_r().entrySet()) {
            StorageLockables lockables = StorageLockables.get(world);
            BlockPos position1 = (BlockPos)entry.getKey();
            if (!(entry.getValue() instanceof TileEntityChest) || lockables.contains(new PredicateIntersecting(new Box(position1)))) continue;
            BlockPos position2 = LocksUtilities.getAdjacentChest((TileEntityChest)entry.getValue());
            lockables.add(new Lockable(new Box(position1, position2 == null ? position1 : position2), new Lock(UUID.randomUUID(), random.nextInt(5, 9), true), (EnumFacing)world.func_180495_p(position1).func_177229_b((IProperty)BlockChest.field_176459_a)));
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos position;
        Box box;
        if (event.getHand() != EnumHand.MAIN_HAND) {
            event.setUseBlock(Event.Result.DENY);
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        StorageLockables lockables = StorageLockables.get(world);
        if (lockables.contains((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(box = new Box(position = event.getPos())), LocksSelectors.LOCKED))) {
            event.setUseBlock(Event.Result.DENY);
            world.func_184133_a(null, position, (SoundEvent)LocksSounds.lock_rattle, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184609_a(EnumHand.MAIN_HAND);
            return;
        }
        if (!(LocksConfiguration.getMain((World)world).remove_locks && player.func_70093_af() && event.getItemStack().func_190926_b() && lockables.contains((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(box), LocksSelectors.NOT_LOCKED)))) {
            return;
        }
        event.setUseBlock(Event.Result.DENY);
        player.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + ThreadLocalRandom.current().nextFloat() * 0.4f);
        player.func_184609_a(EnumHand.MAIN_HAND);
        if (world.field_72995_K) {
            return;
        }
        for (Lockable lockable : lockables.remove(box)) {
            world.func_72838_d((Entity)new EntityItem(world, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, ItemLockable.assignID(new ItemStack(LocksItems.lock), lockable.lock.id)));
        }
    }

    @SubscribeEvent
    public static void onBlockBreaking(PlayerEvent.BreakSpeed event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (!LocksConfiguration.getMain((World)world).unbreakable_locks || !StorageLockables.get(world).contains((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(new Box(event.getPos())), LocksSelectors.LOCKED))) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getPlayer().field_70170_p;
        if (!LocksConfiguration.getMain((World)world).unbreakable_locks || event.getPlayer().func_184812_l_() || !StorageLockables.get(world).contains((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(new Box(event.getPos())), LocksSelectors.LOCKED))) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ICapabilityLockBounds bounds = LocksCapabilities.getLockBounds(event.player);
        if (event.phase != TickEvent.Phase.START || bounds.get() == null) {
            return;
        }
        for (ItemStack stack : event.player.func_184214_aD()) {
            if (!(stack.func_77973_b() instanceof ItemLock)) continue;
            return;
        }
        bounds.set(null);
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("locks")) {
            return;
        }
        ConfigManager.sync((String)"locks", (Config.Type)Config.Type.INSTANCE);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LocksNetworks.network.sendToAll((IMessage)new MessageConfiguration(LocksConfiguration.main));
            }
        };
        server.func_152344_a(runnable);
    }
}

