/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.UUID;
import melonslise.locks.common.capability.InventoryKeyRing;
import melonslise.locks.common.capability.LocksCapabilities;
import melonslise.locks.common.capability.api.CapabilityProviderSerializable;
import melonslise.locks.common.container.ContainerKeyRing;
import melonslise.locks.common.item.api.LocksItem;
import melonslise.locks.common.item.api.lockable.ItemLockable;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.client.MessageKeyRing;
import melonslise.locks.common.sound.LocksSounds;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import melonslise.locks.utility.LocksUtilities;
import melonslise.locks.utility.predicate.PredicateIntersecting;
import melonslise.locks.utility.predicate.PredicateMatching;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemKeyRing
extends LocksItem {
    public final int rows;

    public ItemKeyRing(String name, int rows) {
        super(name);
        this.func_77625_d(1);
        this.rows = rows;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProviderSerializable(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new InventoryKeyRing(this.rows, 9), null);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(player instanceof EntityPlayerMP)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        ContainerKeyRing container = new ContainerKeyRing(player, stack);
        if (!container.func_75145_c(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        LocksUtilities.openContainer((EntityPlayerMP)player, container);
        LocksNetworks.network.sendTo((IMessage)new MessageKeyRing(container, hand), (EntityPlayerMP)player);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos position, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        ItemStack stack = player.func_184586_b(hand);
        StorageLockables lockables = StorageLockables.get(world);
        IItemHandler inventory = LocksCapabilities.getInventory(stack);
        Box box = new Box(position);
        boolean toggled = false;
        for (int a = 0; a < inventory.getSlots(); ++a) {
            UUID id = ItemLockable.getID(inventory.getStackInSlot(a));
            if (world.field_72995_K) {
                if (!StorageLockables.get(world).contains((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(box), (Predicate)new PredicateMatching(id)))) continue;
                toggled = true;
                continue;
            }
            if (StorageLockables.get(world).toggle(box, id).isEmpty()) continue;
            toggled = true;
        }
        if (toggled) {
            world.func_184133_a(player, position, (SoundEvent)LocksSounds.lock_open, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return toggled ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }
}

