/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import melonslise.locks.common.config.LocksConfiguration;
import melonslise.locks.common.container.ContainerLockPicking;
import melonslise.locks.common.item.api.LocksItem;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.client.MessageLockPicking;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import melonslise.locks.utility.LocksUtilities;
import melonslise.locks.utility.predicate.LocksSelectors;
import melonslise.locks.utility.predicate.PredicateIntersecting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemLockPick
extends LocksItem {
    public ItemLockPick(String name) {
        super(name);
    }

    public float getStrength(World world) {
        return LocksConfiguration.getMain((World)world).lock_pick_strength;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos position, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ArrayList<Lockable> lockables = StorageLockables.get(world).matching((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(new Box(position)), LocksSelectors.LOCKED));
        if (lockables.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return EnumActionResult.SUCCESS;
        }
        ContainerLockPicking container = new ContainerLockPicking(player, position, lockables.get(0));
        if (!container.func_75145_c(player)) {
            return EnumActionResult.FAIL;
        }
        LocksUtilities.openContainer((EntityPlayerMP)player, container);
        LocksNetworks.network.sendTo((IMessage)new MessageLockPicking(container), (EntityPlayerMP)player);
        return EnumActionResult.SUCCESS;
    }
}

