/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item.api.lockable;

import java.util.List;
import java.util.UUID;
import melonslise.locks.common.item.api.LocksItem;
import melonslise.locks.utility.LocksUtilities;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemLockable
extends LocksItem {
    public static String keyIdentifier = "identifier";

    public ItemLockable(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        UUID id = ItemLockable.getID(stack);
        if (id != null) {
            tooltip.add(id.toString());
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K) {
            ItemLockable.ensureID(stack);
        }
    }

    public static ItemStack assignID(ItemStack to, UUID id) {
        NBTTagCompound nbt = LocksUtilities.getTag(to);
        if (!nbt.func_186855_b(keyIdentifier)) {
            nbt.func_186854_a(keyIdentifier, id);
        }
        return to;
    }

    public static ItemStack copyID(ItemStack to, ItemStack from) {
        UUID id = ItemLockable.getID(from);
        if (id == null) {
            return to;
        }
        return ItemLockable.assignID(to, id);
    }

    public static UUID getID(ItemStack stack) {
        return LocksUtilities.hasUUID(stack, keyIdentifier) ? stack.func_77978_p().func_186857_a(keyIdentifier) : null;
    }

    public static void ensureID(ItemStack stack) {
        NBTTagCompound nbt = LocksUtilities.getTag(stack);
        if (!nbt.func_186855_b(keyIdentifier)) {
            nbt.func_186854_a(keyIdentifier, UUID.randomUUID());
        }
    }
}

