/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.network.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.common.world.storage.StorageLockables;
import melonslise.locks.utility.LocksUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSetLockables
implements IMessage {
    private ArrayList<Lockable> lockables;

    public MessageSetLockables() {
    }

    public MessageSetLockables(ArrayList<Lockable> lockables) {
        this.lockables = lockables;
    }

    public void fromBytes(ByteBuf buffer) {
        this.lockables = Lists.newArrayList();
        int size = buffer.readInt();
        for (int a = 0; a < size; ++a) {
            this.lockables.add(LocksUtilities.readLockable(buffer));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.lockables.size());
        for (Lockable lockable : this.lockables) {
            LocksUtilities.writeLockable(buffer, lockable);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSetLockables, IMessage> {
        public IMessage onMessage(final MessageSetLockables message, MessageContext context) {
            final Minecraft mc = Minecraft.func_71410_x();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    StorageLockables.get((World)mc.field_71441_e).setLockables(message.lockables);
                }
            };
            mc.func_152344_a(runnable);
            return null;
        }
    }
}

