/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.world.storage;

import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Box {
    public final int x1;
    public final int y1;
    public final int z1;
    public final int x2;
    public final int y2;
    public final int z2;

    public Box(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Box(BlockPos position1, BlockPos position2) {
        this.x1 = Math.min(position1.func_177958_n(), position2.func_177958_n());
        this.y1 = Math.min(position1.func_177956_o(), position2.func_177956_o());
        this.z1 = Math.min(position1.func_177952_p(), position2.func_177952_p());
        this.x2 = Math.max(position1.func_177958_n(), position2.func_177958_n()) + 1;
        this.y2 = Math.max(position1.func_177956_o(), position2.func_177956_o()) + 1;
        this.z2 = Math.max(position1.func_177952_p(), position2.func_177952_p()) + 1;
    }

    public Box(BlockPos position) {
        this(position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), position.func_177958_n() + 1, position.func_177956_o() + 1, position.func_177952_p() + 1);
    }

    public boolean intersects(Box other) {
        return this.x1 < other.x2 && this.x2 > other.x1 && this.y1 < other.y2 && this.y2 > other.y1 && this.z1 < other.z2 && this.z2 > other.z1;
    }

    public int volume() {
        return (this.x2 - this.x1) * (this.y2 - this.y1) * (this.z2 - this.z1);
    }

    public Vec3d center() {
        return new Vec3d((double)(this.x2 + this.x1) / 2.0, (double)(this.y2 + this.y1) / 2.0, (double)(this.z2 + this.z1) / 2.0);
    }

    public static Box readFromNBT(NBTTagCompound nbt) {
        return new Box(nbt.func_74762_e("x1"), nbt.func_74762_e("y1"), nbt.func_74762_e("z1"), nbt.func_74762_e("x2"), nbt.func_74762_e("y2"), nbt.func_74762_e("z2"));
    }

    public static NBTTagCompound writeToNBT(Box box) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x1", box.x1);
        nbt.func_74768_a("y1", box.y1);
        nbt.func_74768_a("z1", box.z1);
        nbt.func_74768_a("x2", box.x2);
        nbt.func_74768_a("y2", box.y2);
        nbt.func_74768_a("z2", box.z2);
        return nbt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Box)) {
            return false;
        }
        Box box = (Box)object;
        return this.x1 == box.x1 && this.x2 == box.x2 && this.y1 == box.y1 && this.y2 == box.y2 && this.z1 == box.z1 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{" + this.x1 + ", " + this.y1 + ", " + this.z1 + ", " + this.x2 + ", " + this.y2 + ", " + this.z2 + "}";
    }
}

