/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.world.storage;

import java.util.Objects;
import java.util.UUID;
import melonslise.locks.utility.LocksUtilities;
import net.minecraft.nbt.NBTTagCompound;

public class Lock {
    public final UUID id;
    protected byte[] combination;
    boolean locked;
    public static final String keyID = "id";
    public static final String keyCombination = "combination";
    public static final String keyLocked = "locked";

    protected Lock(UUID id, byte[] combination, boolean locked) {
        this.id = id;
        this.combination = combination;
        this.locked = locked;
    }

    public Lock(UUID id, int length, boolean locked) {
        this.id = id;
        this.combination = new byte[length];
        for (int a = 0; a < length; a = (int)((byte)(a + 1))) {
            this.combination[a] = a;
        }
        this.shuffle();
        this.locked = locked;
    }

    public int getLength() {
        return this.combination.length;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean checkPin(int index, int pin) {
        return this.combination[index] == pin;
    }

    void shuffle() {
        LocksUtilities.shuffle(this.combination);
    }

    public static Lock readFromNBT(NBTTagCompound nbt) {
        return new Lock(nbt.func_186857_a(keyID), nbt.func_74770_j(keyCombination), nbt.func_74767_n(keyLocked));
    }

    public static NBTTagCompound writeToNBT(Lock lock) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_186854_a(keyID, lock.id);
        nbt.func_74773_a(keyCombination, lock.combination);
        nbt.func_74757_a(keyLocked, lock.locked);
        return nbt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Lock)) {
            return false;
        }
        Lock lock = (Lock)object;
        return (this.id == null && lock.id == null || this.id.equals(lock.id)) && (this.combination == null && lock.combination == null || this.combination.equals(lock.combination)) && this.locked == lock.locked;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.combination, this.locked);
    }
}

