/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.world.storage;

import java.util.Objects;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class Lockable {
    public final Box box;
    public final Lock lock;
    public final EnumFacing side;
    public static final String keyBox = "box";
    public static final String keyLock = "lock";
    public static final String keySide = "side";

    public Lockable(Box box, Lock lock, EnumFacing side) {
        this.box = box;
        this.lock = lock;
        this.side = side;
    }

    public static Lockable readFromNBT(NBTTagCompound nbt) {
        return new Lockable(Box.readFromNBT(nbt.func_74775_l(keyBox)), Lock.readFromNBT(nbt.func_74775_l(keyLock)), EnumFacing.func_82600_a((int)nbt.func_74771_c(keySide)));
    }

    public static NBTTagCompound writeToNBT(Lockable lockable) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(keyBox, (NBTBase)Box.writeToNBT(lockable.box));
        nbt.func_74782_a(keyLock, (NBTBase)Lock.writeToNBT(lockable.lock));
        nbt.func_74774_a(keySide, (byte)lockable.side.func_176745_a());
        return nbt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)object;
        return (this.box == null && lockable.box == null || this.box.equals(lockable.box)) && (this.lock == null && lockable.lock == null || this.lock.equals(lockable.lock)) && (this.side == null && lockable.side == null || this.side.equals((Object)lockable.side));
    }

    public int hashCode() {
        return Objects.hash(this.box, this.lock, this.side);
    }
}

