/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.world.storage;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import melonslise.locks.common.config.LocksConfiguration;
import melonslise.locks.common.network.LocksNetworks;
import melonslise.locks.common.network.client.MessageAddLockable;
import melonslise.locks.common.network.client.MessageRemoveLockables;
import melonslise.locks.common.network.client.MessageSetLockables;
import melonslise.locks.common.network.client.MessageToggleLockables;
import melonslise.locks.common.network.client.MessageToggleLockablesByID;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lockable;
import melonslise.locks.utility.LocksUtilities;
import melonslise.locks.utility.predicate.PredicateIntersecting;
import melonslise.locks.utility.predicate.PredicateMatching;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageLockables
extends WorldSavedData {
    public static final String name = LocksUtilities.prefixLocks("lockables");
    protected World world;
    protected ArrayList<Lockable> lockables = Lists.newArrayList();
    public static final String keyLockables = "lockables";

    public StorageLockables(String name) {
        super(name);
    }

    public void setLockables(ArrayList<Lockable> lockables) {
        this.lockables = lockables;
        this.synchronize();
    }

    public ArrayList<Lockable> getLockables() {
        return (ArrayList)this.lockables.clone();
    }

    public static StorageLockables get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        StorageLockables instance = (StorageLockables)storage.func_75742_a(StorageLockables.class, name);
        if (instance == null) {
            instance = new StorageLockables(name);
            storage.func_75745_a(name, (WorldSavedData)instance);
        }
        instance.world = world;
        return instance;
    }

    public void synchronize() {
        if (!this.world.field_72995_K) {
            LocksNetworks.network.sendToDimension((IMessage)new MessageSetLockables(this.lockables), this.world.field_73011_w.getDimension());
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c(keyLockables, 10);
        for (int a = 0; a < list.func_74745_c(); ++a) {
            this.lockables.add(Lockable.readFromNBT(list.func_150305_b(a)));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Lockable lockable : this.lockables) {
            list.func_74742_a((NBTBase)Lockable.writeToNBT(lockable));
        }
        nbt.func_74782_a(keyLockables, (NBTBase)list);
        return nbt;
    }

    public boolean add(Lockable lockable) {
        if (lockable == null || lockable.box == null || lockable.lock == null || lockable.lock.id == null || lockable.side == null || lockable.box.volume() > LocksConfiguration.getMain((World)this.world).lockable_volume || this.contains(new PredicateIntersecting(lockable.box))) {
            return false;
        }
        this.lockables.add(lockable);
        if (this.world.field_72995_K) {
            return true;
        }
        LocksNetworks.network.sendToDimension((IMessage)new MessageAddLockable(lockable), this.world.field_73011_w.getDimension());
        this.func_76185_a();
        return true;
    }

    public boolean contains(Predicate<Lockable> condition) {
        for (Lockable lockable : this.lockables) {
            if (!condition.apply((Object)lockable)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Lockable> matching(Predicate<Lockable> condition) {
        ArrayList matching = Lists.newArrayList();
        for (Lockable lockable : this.lockables) {
            if (!condition.apply((Object)lockable)) continue;
            matching.add(lockable);
        }
        return matching;
    }

    public ArrayList<Lockable> remove(Box box) {
        ArrayList<Lockable> matching = this.matching(new PredicateIntersecting(box));
        for (Lockable lockable : matching) {
            this.lockables.remove(lockable);
        }
        if (this.world.field_72995_K || matching.isEmpty()) {
            return matching;
        }
        LocksNetworks.network.sendToDimension((IMessage)new MessageRemoveLockables(box), this.world.field_73011_w.getDimension());
        this.func_76185_a();
        return matching;
    }

    public ArrayList<Lockable> toggle(Box box) {
        ArrayList<Lockable> matching = this.matching(new PredicateIntersecting(box));
        for (Lockable lockable : matching) {
            lockable.lock.locked = !lockable.lock.locked;
        }
        if (this.world.field_72995_K || matching.isEmpty()) {
            return matching;
        }
        LocksNetworks.network.sendToDimension((IMessage)new MessageToggleLockables(box), this.world.field_73011_w.getDimension());
        this.func_76185_a();
        return matching;
    }

    public ArrayList<Lockable> toggle(Box box, UUID id) {
        ArrayList<Lockable> matching = this.matching((Predicate<Lockable>)Predicates.and((Predicate)new PredicateIntersecting(box), (Predicate)new PredicateMatching(id)));
        for (Lockable lockable : matching) {
            lockable.lock.locked = !lockable.lock.locked;
        }
        if (this.world.field_72995_K || matching.isEmpty()) {
            return matching;
        }
        LocksNetworks.network.sendToDimension((IMessage)new MessageToggleLockablesByID(box, id), this.world.field_73011_w.getDimension());
        this.func_76185_a();
        return matching;
    }

    public void shuffleCombination(Lockable lockable) {
        lockable.lock.shuffle();
        if (!this.world.field_72995_K && this.lockables.contains(lockable)) {
            this.func_76185_a();
        }
    }
}

