/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.utility;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import melonslise.locks.common.config.LocksConfiguration;
import melonslise.locks.common.world.storage.Box;
import melonslise.locks.common.world.storage.Lock;
import melonslise.locks.common.world.storage.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class LocksUtilities {
    private LocksUtilities() {
    }

    public static String prefixLocks(String path) {
        return String.join((CharSequence)".", "locks", path);
    }

    public static ResourceLocation createLocksDomain(String path) {
        return new ResourceLocation("locks", path);
    }

    public static void shuffle(byte[] array) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int a = array.length - 1; a > 0; --a) {
            int index = random.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static boolean hasUUID(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_186855_b(key);
    }

    public static UUID readUUID(ByteBuf buffer) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    public static void writeUUID(ByteBuf buffer, UUID uuid) {
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
    }

    public static BlockPos readPosition(ByteBuf buffer) {
        return new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void writePosition(ByteBuf buffer, BlockPos position) {
        buffer.writeInt(position.func_177958_n());
        buffer.writeInt(position.func_177956_o());
        buffer.writeInt(position.func_177952_p());
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buffer, Class<T> c) {
        return (T)((Enum[])c.getEnumConstants())[buffer.readByte()];
    }

    public static void writeEnum(ByteBuf buffer, Enum<?> value) {
        buffer.writeByte((int)((byte)value.ordinal()));
    }

    public static Box readBox(ByteBuf buffer) {
        return new Box(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void writeBox(ByteBuf buffer, Box box) {
        buffer.writeInt(box.x1);
        buffer.writeInt(box.y1);
        buffer.writeInt(box.z1);
        buffer.writeInt(box.x2);
        buffer.writeInt(box.y2);
        buffer.writeInt(box.z2);
    }

    public static Lock readLock(ByteBuf buffer) {
        return new Lock(LocksUtilities.readUUID(buffer), buffer.readByte(), buffer.readBoolean());
    }

    public static void writeLock(ByteBuf buffer, Lock lock) {
        LocksUtilities.writeUUID(buffer, lock.id);
        buffer.writeByte(lock.getLength());
        buffer.writeBoolean(lock.isLocked());
    }

    public static Lockable readLockable(ByteBuf buffer) {
        return new Lockable(LocksUtilities.readBox(buffer), LocksUtilities.readLock(buffer), LocksUtilities.readEnum(buffer, EnumFacing.class));
    }

    public static void writeLockable(ByteBuf buffer, Lockable lockable) {
        LocksUtilities.writeBox(buffer, lockable.box);
        LocksUtilities.writeLock(buffer, lockable.lock);
        LocksUtilities.writeEnum(buffer, lockable.side);
    }

    public static int openContainer(EntityPlayerMP player, Container container) {
        player.func_71117_bO();
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        return player.field_71139_cq;
    }

    public static boolean canLock(World world, BlockPos position) {
        return ArrayUtils.contains((Object[])LocksConfiguration.getMain((World)world).lockable_blocks, (Object)world.func_180495_p(position).func_177230_c().getRegistryName().toString());
    }

    public static Vec3d getRenderOrigin(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return new Vec3d(mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick, mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTick, mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
    }

    public static Vec3d getBoxSideCenter(Box box, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d((double)(box.x1 + box.x2) / 2.0, (double)box.y1, (double)(box.z1 + box.z2) / 2.0);
            }
            case UP: {
                return new Vec3d((double)(box.x1 + box.x2) / 2.0, (double)box.y2, (double)(box.z1 + box.z2) / 2.0);
            }
            case NORTH: {
                return new Vec3d((double)(box.x1 + box.x2) / 2.0, (double)(box.y1 + box.y2) / 2.0, (double)box.z1);
            }
            case SOUTH: {
                return new Vec3d((double)(box.x1 + box.x2) / 2.0, (double)(box.y1 + box.y2) / 2.0, (double)box.z2);
            }
            case WEST: {
                return new Vec3d((double)box.x1, (double)(box.y1 + box.y2) / 2.0, (double)(box.z1 + box.z2) / 2.0);
            }
            case EAST: {
                return new Vec3d((double)box.x2, (double)(box.y1 + box.y2) / 2.0, (double)(box.z1 + box.z2) / 2.0);
            }
        }
        return null;
    }

    public static Vec3d getBoxSideCenter(AxisAlignedBB box, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72338_b, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case UP: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72337_e, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case NORTH: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72339_c);
            }
            case SOUTH: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72334_f);
            }
            case WEST: {
                return new Vec3d(box.field_72340_a, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case EAST: {
                return new Vec3d(box.field_72336_d, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
        }
        return null;
    }

    public static BlockPos getAdjacentChest(TileEntityChest chest) {
        BlockPos position = null;
        chest.func_145979_i();
        if (chest.field_145991_k != null) {
            position = chest.field_145991_k.func_174877_v();
        } else if (chest.field_145990_j != null) {
            position = chest.field_145990_j.func_174877_v();
        } else if (chest.field_145992_i != null) {
            position = chest.field_145992_i.func_174877_v();
        } else if (chest.field_145988_l != null) {
            position = chest.field_145988_l.func_174877_v();
        }
        return position;
    }
}

