/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Orientation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="locks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksClientForgeEvents {
    public static final ItemStack LOCK_STACK = new ItemStack((IItemProvider)LocksItems.LOCK);

    private LocksClientForgeEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END || mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> lockables.get().values().forEach(lockable -> {
            if (lockable.box.loaded((World)mc.field_71441_e)) {
                lockable.tick();
            }
        }));
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (Lockable lockable : lockables.get().values()) {
                Pair<Vec3d, Orientation> pair;
                if (!lockable.box.loaded((World)mc.field_71441_e) || !lockable.inRange() || !lockable.box.inView() || (pair = lockable.getLockState((World)mc.field_71441_e)) == null) continue;
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(((Vec3d)pair.getLeft()).field_72450_a - TileEntityRendererDispatcher.field_147554_b), (double)(((Vec3d)pair.getLeft()).field_72448_b - TileEntityRendererDispatcher.field_147555_c), (double)(((Vec3d)pair.getLeft()).field_72449_c - TileEntityRendererDispatcher.field_147552_d));
                GlStateManager.rotatef((float)(-((Orientation)((Object)((Object)pair.getRight()))).dir.func_185119_l() - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                if (((Orientation)((Object)((Object)pair.getRight()))).face != AttachFace.WALL) {
                    GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GlStateManager.translated((double)0.0, (double)0.1, (double)0.0);
                GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lockable.maxShakeTicks - lockable.prevShakeTicks, lockable.maxShakeTicks - lockable.shakeTicks, event.getPartialTicks()) / (float)lockable.maxShakeTicks) * (float)lockable.maxShakeTicks / 5.0f * 3.14f)) * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translated((double)0.0, (double)-0.1, (double)0.0);
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                int lightValue = mc.field_71441_e.func_217338_b(new BlockPos((Vec3d)pair.getLeft()), 0);
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)(lightValue % 65536), (float)(lightValue / 65536));
                mc.field_71460_t.func_180436_i();
                mc.func_175599_af().func_181564_a(LOCK_STACK, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.popMatrix();
            }
        });
        mc.field_71439_g.getCapability(LocksCapabilities.LOCK_SELECTION).ifPresent(select -> {
            BlockPos pos1 = select.get();
            if (pos1 == null) {
                return;
            }
            BlockPos pos2 = mc.field_71476_x instanceof BlockRayTraceResult ? ((BlockRayTraceResult)mc.field_71476_x).func_216350_a() : pos1;
            Cuboid6i box = new Cuboid6i(pos1, pos2);
            float r = 0.0f;
            float g = 0.0f;
            if (box.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get() || !LocksServerConfig.canLock((World)mc.field_71441_e, pos2)) {
                r = 1.0f;
            } else {
                g = 1.0f;
            }
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.lineWidth((float)1.0f);
            GlStateManager.disableTexture();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepthTest();
            mc.field_71460_t.func_175072_h();
            WorldRenderer.func_189694_a((double)((double)box.x1 - TileEntityRendererDispatcher.field_147554_b), (double)((double)box.y1 - TileEntityRendererDispatcher.field_147555_c), (double)((double)box.z1 - TileEntityRendererDispatcher.field_147552_d), (double)((double)box.x2 - TileEntityRendererDispatcher.field_147554_b), (double)((double)box.y2 - TileEntityRendererDispatcher.field_147555_c), (double)((double)box.z2 - TileEntityRendererDispatcher.field_147552_d), (float)r, (float)g, (float)0.0f, (float)0.5f);
            GlStateManager.enableDepthTest();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableTexture();
            GlStateManager.disableBlend();
        });
    }
}

