/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import melonslise.locks.client.gui.sprite.LockPickSprite;
import melonslise.locks.client.gui.sprite.PinSprite;
import melonslise.locks.client.gui.sprite.Texture;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.network.toserver.CheckPinPacket;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LockPickingScreen
extends ContainerScreen<LockPickingContainer> {
    protected int length;
    public static final ResourceLocation TEXTURE = new ResourceLocation("locks", "textures/gui/lockpicking.png");
    public static final ITextComponent HINT = new TranslationTextComponent("locks.gui.lockpicking.open", new Object[0]);
    protected Texture outerLock = new Texture(24, 0, 24, 120, 256, 256);
    protected Texture innerLock = new Texture(0, 0, 24, 64, 256, 256);
    protected Texture spring = new Texture(48, 48, 12, 24, 256, 256);
    protected Texture edge = new Texture(0, 0, 12, 64, 256, 256);
    protected Texture pin = new Texture(48, 0, 12, 48, 256, 256);
    protected LockPickSprite lockPick = new LockPickSprite(new Texture(60, 0, 192, 24, 256, 256));
    protected PinSprite[] pins;
    protected int currentPin;

    public LockPickingScreen(LockPickingContainer container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        this.setLength(container.lockable.lock.getLength());
    }

    public void setLength(int length) {
        this.length = length;
        this.field_146999_f = 12 + this.length * 24 + 12;
        this.field_147000_g = 120;
        this.pins = new PinSprite[length];
        for (int a = 0; a < this.pins.length; ++a) {
            this.pins[a] = new PinSprite(this.pin);
        }
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTick);
    }

    public void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int a;
        float pt = this.minecraft.func_184121_ak();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.width - this.field_146999_f) / 2;
        int cornerY = (this.height - this.field_147000_g) / 2;
        for (a = 0; a < this.length + 1; ++a) {
            this.outerLock.draw(cornerX + a * 24, cornerY);
        }
        for (a = 0; a < this.length; ++a) {
            this.innerLock.draw(cornerX + a * 24 + 12, cornerY + 48);
        }
        this.edge.draw(cornerX + this.length * 24 + 12, cornerY + 48);
        this.lockPick.draw(cornerX - 156, cornerY + 72, pt);
        for (a = 0; a < this.pins.length; ++a) {
            this.spring.draw(cornerX + a * 24 + 18, cornerY);
            this.pins[a].draw(cornerX + a * 24 + 18, cornerY + 24, pt);
        }
        this.edge.draw(cornerX, cornerY + 48);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String string = this.title.func_150254_d();
        this.font.getClass();
        this.font.func_211126_b(string, 0.0f, (float)(-9), 0xFFFFFF);
        if (((LockPickingContainer)this.func_212873_a_()).isOpen()) {
            this.font.func_211126_b(HINT.func_150254_d(), (float)(this.field_146999_f - this.font.func_78256_a(HINT.func_150254_d())) / 2.0f, (float)(this.field_147000_g + 10), 0xFFFFFF);
        }
    }

    public void tick() {
        super.tick();
        this.lockPick.update();
        this.boundLockPick();
        for (int a = 0; a < this.length; ++a) {
            this.pins[a].update();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int key, int scan, int modifier) {
        if (key == this.minecraft.field_71474_y.field_74370_x.getKey().func_197937_c()) {
            this.lockPick.motionX = -6.0f;
            return true;
        }
        if (key == this.minecraft.field_71474_y.field_74366_z.getKey().func_197937_c()) {
            this.lockPick.motionX = 6.0f;
            return true;
        }
        if (key == this.minecraft.field_71474_y.field_74351_w.getKey().func_197937_c() && this.lockPick.rotation == 0.0f) {
            this.rotateLockPick(-6);
            this.pullPin(this.getSelectedPin());
            return true;
        }
        return super.keyPressed(key, scan, modifier);
    }

    public boolean func_223281_a_(int key, int scan, int modifier) {
        if (key == this.minecraft.field_71474_y.field_74370_x.getKey().func_197937_c()) {
            this.lockPick.motionX = 0.0f;
            return true;
        }
        if (key == this.minecraft.field_71474_y.field_74366_z.getKey().func_197937_c()) {
            this.lockPick.motionX = 0.0f;
            return true;
        }
        return super.func_223281_a_(key, scan, modifier);
    }

    protected void boundLockPick() {
        this.lockPick.shiftX = MathHelper.func_76131_a((float)this.lockPick.shiftX, (float)0.0f, (float)((this.length - 1) * 24));
    }

    protected void rotateLockPick(int deg) {
        int motion = 2 * Integer.signum(deg);
        this.lockPick.rotate(motion, deg / motion);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.shiftX + 12.0f) / 24.0f);
    }

    protected void pullPin(int pin) {
        if (this.pins[pin].isPulled) {
            return;
        }
        this.currentPin = pin;
        LocksNetworks.MAIN.sendToServer((Object)new CheckPinPacket((byte)pin));
    }

    public void handlePin(boolean correct, boolean reset) {
        this.pins[this.currentPin].moveY(-8.0f, 3);
        if (correct) {
            this.pins[this.currentPin].isPulled = true;
        }
        if (reset) {
            this.reset();
        }
    }

    public void reset() {
        this.lockPick.reset();
        for (PinSprite pin : this.pins) {
            pin.isPulled = false;
        }
    }
}

