/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui.sprite;

import com.mojang.blaze3d.platform.GlStateManager;
import melonslise.locks.client.gui.sprite.Sprite;
import melonslise.locks.client.gui.sprite.Texture;
import melonslise.locks.client.util.LocksClientUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RotatableSprite
extends Sprite {
    public float rotation;
    public float oldRotation;
    public float motionRotation;
    public float originX;
    public float originY;
    public int ticksRotation;

    public RotatableSprite(Texture tex) {
        super(tex);
        this.originX = this.texture.width / 2;
        this.originY = this.texture.height / 2;
    }

    @Override
    public void draw(float x, float y, float partialTick) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.originX + this.shiftX), (float)(this.originY + this.shiftY), (float)0.0f);
        GlStateManager.rotatef((float)LocksClientUtil.lerp(this.oldRotation, this.rotation, partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)(-this.originX - this.shiftX), (float)(-this.originY - this.shiftY), (float)0.0f);
        super.draw(x, y, partialTick);
        GlStateManager.popMatrix();
    }

    @Override
    public void update() {
        super.update();
        this.rotate();
    }

    protected void rotate() {
        this.oldRotation = this.rotation;
        if (this.ticksRotation > 0) {
            this.rotation += this.motionRotation;
            --this.ticksRotation;
            if (this.ticksRotation <= 0) {
                this.motionRotation = 0.0f;
            }
        } else {
            this.rotation += this.motionRotation;
        }
    }

    public void rotate(float motion, int ticks) {
        this.motionRotation = motion;
        this.ticksRotation = ticks;
    }

    @Override
    public void reset() {
        super.reset();
        this.motionRotation = 0.0f;
        this.oldRotation = 0.0f;
        this.rotation = 0.0f;
        this.ticksRotation = 0;
    }
}

