/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksSoundEvents;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class KeyRingContainer
extends Container {
    public final ItemStack stack;
    public final IItemHandler inv;
    public final int rows;
    public static final IContainerFactory<KeyRingContainer> FACTORY = (id, inv, buffer) -> new KeyRingContainer(id, inv.field_70458_d, inv.field_70458_d.func_184586_b((Hand)buffer.func_179257_a(Hand.class)));

    public KeyRingContainer(int id, PlayerEntity player, ItemStack stack) {
        super(LocksContainerTypes.KEY_RING, id);
        int column;
        this.stack = stack;
        this.inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        this.rows = this.inv.getSlots() / 9;
        for (int row = 0; row < this.rows; ++row) {
            for (column = 0; column < 9; ++column) {
                this.func_75146_a((Slot)new KeyRingSlot(player, this.inv, column + row * 9, 8 + column * 18, 18 + row * 18));
            }
        }
        int offset = (this.rows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, column2 + row * 9 + 9, 8 + column2 * 18, 103 + row * 18 + offset));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, column, 8 + column * 18, 161 + offset));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return !this.stack.func_190926_b();
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return stack;
        }
        ItemStack stack1 = slot.func_75211_c();
        stack = stack1.func_77946_l();
        if (index < this.inv.getSlots() ? !this.func_75135_a(stack1, this.inv.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(stack1, 0, this.inv.getSlots(), false)) {
            return ItemStack.field_190927_a;
        }
        if (stack1.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return stack;
    }

    public static class Writer
    implements Consumer<PacketBuffer> {
        public final Hand hand;

        public Writer(Hand hand) {
            this.hand = hand;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)this.hand);
        }
    }

    public static class Provider
    implements INamedContainerProvider {
        public final ItemStack stack;

        public Provider(ItemStack stack) {
            this.stack = stack;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
            return new KeyRingContainer(id, player, this.stack);
        }

        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }
    }

    public static class KeyRingSlot
    extends SlotItemHandler {
        public final PlayerEntity player;

        public KeyRingSlot(PlayerEntity player, IItemHandler inv, int index, int x, int y) {
            super(inv, index, x, y);
            this.player = player;
        }

        public void func_75215_d(ItemStack stack) {
            super.func_75215_d(stack);
            if (!this.player.field_70170_p.field_72995_K) {
                this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, LocksSoundEvents.KEY_RING, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            if (!this.player.field_70170_p.field_72995_K) {
                this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, LocksSoundEvents.KEY_RING, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return super.func_190901_a(player, stack);
        }
    }
}

