/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.coremod;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import melonslise.locks.coremod.LockableInfo;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public final class LocksDelegates {
    public static final String KEY_LOCKABLES = "lockables";

    private LocksDelegates() {
    }

    public static void onBlockUpdate(World world, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            world.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(pos)).forEach(lockable -> {
                world.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, LockItem.from(lockable.lock)));
                lockables.remove(lockable.networkID);
            }));
        }
    }

    public static List<LockableInfo> takeLockablesFromWorld(World world, BlockPos start, BlockPos size) {
        return (List)world.getCapability(LocksCapabilities.LOCKABLES).map(lockables -> {
            Cuboid6i box = new Cuboid6i(start, start.func_177982_a(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p() - 1));
            return lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(box)).map(lockable -> {
                Cuboid6i newBox = box.intersection(lockable.box).offset(-start.func_177958_n(), -start.func_177956_o(), -start.func_177952_p());
                return new LockableInfo(newBox, lockable.lock, lockable.orient);
            }).collect(Collectors.toList());
        }).orElse((Object)Lists.newArrayList());
    }

    public static void addLockablesToWorld(List<LockableInfo> infos, IWorld world, BlockPos start, PlacementSettings settings) {
        world.func_201672_e().getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (LockableInfo lockable : infos) {
                BlockPos pos1 = LocksUtil.transformPos(lockable.box.x1, lockable.box.y1, lockable.box.z1, settings);
                BlockPos pos2 = LocksUtil.transformPos(lockable.box.x2, lockable.box.y2, lockable.box.z2, settings);
                Cuboid6i box = new Cuboid6i(pos1.func_177958_n() + start.func_177958_n(), pos1.func_177956_o() + start.func_177956_o(), pos1.func_177952_p() + start.func_177952_p(), pos2.func_177958_n() + start.func_177958_n(), pos2.func_177956_o() + start.func_177956_o(), pos2.func_177952_p() + start.func_177952_p());
                Lock lock = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? new Lock(world.func_201674_k().nextInt(), LocksConfig.randLockLen(world.func_201674_k()), true) : lockable.lock;
                Orientation orient = Orientation.fromDirectionAndFace(settings.func_186215_c().func_185831_a(settings.func_186212_b().func_185800_a(lockable.lockOrientation.dir).func_185831_a(lockable.lockOrientation.dir)), lockable.lockOrientation.face, Direction.NORTH);
                lockables.add(new Lockable(box, lock, orient));
            }
        });
    }

    public static void writeLockablesToNBT(CompoundNBT nbt, List<LockableInfo> infos) {
        ListNBT lockableNBTList = new ListNBT();
        for (LockableInfo lockable : infos) {
            CompoundNBT lockableNBT = new CompoundNBT();
            lockableNBT.func_218657_a("box", (INBT)LocksUtil.writeBoxToNBT(lockable.box));
            lockableNBT.func_218657_a("lock", (INBT)LocksUtil.writeLockToNBT(lockable.lock));
            lockableNBT.func_74774_a("orientation", (byte)lockable.lockOrientation.ordinal());
            lockableNBTList.add((Object)lockableNBT);
        }
        nbt.func_218657_a(KEY_LOCKABLES, (INBT)lockableNBTList);
    }

    public static List<LockableInfo> readLockablesFromNBT(CompoundNBT nbt) {
        ArrayList list = Lists.newArrayList();
        ListNBT nbtList = nbt.func_150295_c(KEY_LOCKABLES, 10);
        int b = nbtList.size();
        for (int a = 0; a < b; ++a) {
            CompoundNBT lockableNBT = nbtList.func_150305_b(a);
            Cuboid6i box = LocksUtil.readBoxFromNBT(lockableNBT.func_74775_l("box"));
            Lock lock = LocksUtil.readLockFromNBT(lockableNBT.func_74775_l("lock"));
            Orientation orient = Orientation.values()[lockableNBT.func_74771_c("orientation")];
            list.add(new LockableInfo(box, lock, orient));
        }
        return list;
    }
}

