/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import melonslise.locks.client.init.LocksRenderTypes;
import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Orientation;
import melonslise.locks.coremod.LocksDelegates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="locks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksClientForgeEvents {
    public static final ItemStack LOCK_STACK = new ItemStack((IItemProvider)LocksItems.LOCK);

    private LocksClientForgeEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END || mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> lockables.get().values().forEach(lockable -> {
            if (lockable.box.loaded((World)mc.field_71441_e)) {
                lockable.tick();
            }
        }));
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d origin = mc.field_71460_t.func_215316_n().func_216785_c();
        IRenderTypeBuffer.Impl buf = mc.func_228019_au_().func_228487_b_();
        MatrixStack mtx = event.getMatrixStack();
        BlockPos.Mutable mutPos = new BlockPos.Mutable();
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (Lockable lockable : lockables.get().values()) {
                Pair<Vec3d, Orientation> pair;
                if (!lockable.box.loaded((World)mc.field_71441_e) || !lockable.inRange() || !lockable.box.inView(LocksDelegates.clippingHelper) || (pair = lockable.getLockState((World)mc.field_71441_e)) == null) continue;
                Vec3d lockPos = (Vec3d)pair.getLeft();
                mtx.func_227860_a_();
                mtx.func_227861_a_(lockPos.field_72450_a - origin.field_72450_a, lockPos.field_72448_b - origin.field_72448_b, lockPos.field_72449_c - origin.field_72449_c);
                mtx.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-((Orientation)((Object)((Object)pair.getRight()))).dir.func_185119_l() - 180.0f));
                if (((Orientation)((Object)((Object)pair.getRight()))).face != AttachFace.WALL) {
                    mtx.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                mtx.func_227861_a_(0.0, 0.1, 0.0);
                mtx.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lockable.maxShakeTicks - lockable.prevShakeTicks, lockable.maxShakeTicks - lockable.shakeTicks, event.getPartialTicks()) / (float)lockable.maxShakeTicks) * (float)lockable.maxShakeTicks / 5.0f * 3.14f)) * 10.0f));
                mtx.func_227861_a_(0.0, -0.1, 0.0);
                mtx.func_227862_a_(0.5f, 0.5f, 0.5f);
                int packedLight = WorldRenderer.func_228421_a_((ILightReader)mc.field_71441_e, (BlockPos)mutPos.func_189532_c(lockPos.field_72450_a, lockPos.field_72448_b, lockPos.field_72449_c));
                mc.func_175599_af().func_229110_a_(LOCK_STACK, ItemCameraTransforms.TransformType.FIXED, packedLight, OverlayTexture.field_229196_a_, mtx, (IRenderTypeBuffer)buf);
                RenderSystem.disableDepthTest();
                buf.func_228461_a_();
                mtx.func_227865_b_();
            }
        });
        mc.field_71439_g.getCapability(LocksCapabilities.LOCK_SELECTION).ifPresent(select -> {
            BlockPos pos1 = select.get();
            if (pos1 == null) {
                return;
            }
            BlockPos pos2 = mc.field_71476_x instanceof BlockRayTraceResult ? ((BlockRayTraceResult)mc.field_71476_x).func_216350_a() : pos1;
            Cuboid6i box = new Cuboid6i(pos1, pos2);
            float r = 0.0f;
            float g = 0.0f;
            if (box.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get() || !LocksServerConfig.canLock((World)mc.field_71441_e, pos2)) {
                r = 1.0f;
            } else {
                g = 1.0f;
            }
            mtx.func_227860_a_();
            WorldRenderer.func_228427_a_((MatrixStack)mtx, (IVertexBuilder)buf.getBuffer(LocksRenderTypes.OVERLAY_LINES), (double)((double)box.x1 - origin.field_72450_a), (double)((double)box.y1 - origin.field_72448_b), (double)((double)box.z1 - origin.field_72449_c), (double)((double)box.x2 - origin.field_72450_a), (double)((double)box.y2 - origin.field_72448_b), (double)((double)box.z2 - origin.field_72449_c), (float)r, (float)g, (float)0.0f, (float)0.5f);
            RenderSystem.disableDepthTest();
            buf.func_228461_a_();
            mtx.func_227865_b_();
        });
    }
}

