/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import javax.annotation.Nullable;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Orientation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockItem
extends LockingItem {
    public static final byte DEFAULT_LENGTH = 7;
    public static final String KEY_LENGTH = "Length";

    public LockItem(Item.Properties props) {
        super(props);
    }

    public static ItemStack from(Lock lock) {
        ItemStack stack = new ItemStack((IItemProvider)LocksItems.LOCK);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("id", lock.id);
        nbt.func_74768_a(KEY_LENGTH, lock.getLength());
        return stack;
    }

    public static byte getOrSetLength(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b(KEY_LENGTH)) {
            nbt.func_74774_a(KEY_LENGTH, (byte)7);
        }
        return nbt.func_74771_c(KEY_LENGTH);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        return (ActionResultType)world.getCapability(LocksCapabilities.LOCKABLES).map(lockables -> (ActionResultType)player.getCapability(LocksCapabilities.LOCK_SELECTION).map(select -> {
            if (!LocksServerConfig.canLock(world, pos) || lockables.get().values().stream().anyMatch(lockable1 -> lockable1.box.intersects(pos))) {
                return ActionResultType.PASS;
            }
            BlockPos pos1 = select.get();
            if (pos1 == null) {
                select.set(pos);
            } else {
                select.set(null);
                world.func_184133_a(player, pos, LocksSoundEvents.LOCK_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                if (!lockables.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(stack), Orientation.fromDirection(ctx.func_196000_l(), ctx.func_195992_f().func_176734_d())))) {
                    return ActionResultType.PASS;
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }).orElse((Object)ActionResultType.PASS)).orElse((Object)ActionResultType.PASS);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        LockItem.getOrSetLength(stack);
        items.add((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_LENGTH)) {
            lines.add(new TranslationTextComponent("locks.tooltip.length", new Object[]{ItemStack.field_111284_a.format(LockItem.getOrSetLength(stack))}).func_211708_a(TextFormatting.DARK_GREEN));
        }
    }
}

