/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import melonslise.locks.Locks;
import melonslise.locks.common.capability.CapabilityProvider;
import melonslise.locks.common.capability.KeyRingInventory;
import melonslise.locks.common.container.KeyRingContainer;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Lockable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class KeyRingItem
extends Item {
    public final int rows;

    public KeyRingItem(Item.Properties props, int rows) {
        super(props);
        this.rows = rows;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProvider<KeyRingInventory>(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new KeyRingInventory(stack, this.rows, 9));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new KeyRingContainer.Provider(player.func_184586_b(hand)), (Consumer)new KeyRingContainer.Writer(hand));
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        return (ActionResultType)Locks.PROXY.getLockables(world).map(lockables -> (ActionResultType)ctx.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(inv -> {
            List intersecting = lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(pos)).collect(Collectors.toList());
            if (intersecting.isEmpty()) {
                return ActionResultType.PASS;
            }
            for (int a = 0; a < inv.getSlots(); ++a) {
                int id = LockingItem.getOrSetId(inv.getStackInSlot(a));
                List matching = intersecting.stream().filter(lockable1 -> lockable1.lock.id == id).collect(Collectors.toList());
                if (matching.isEmpty()) continue;
                for (Lockable lockable : matching) {
                    lockable.lock.setLocked(!lockable.lock.isLocked());
                }
                world.func_184133_a(ctx.func_195999_j(), pos, LocksSoundEvents.LOCK_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }).orElse((Object)ActionResultType.PASS)).orElse((Object)ActionResultType.PASS);
    }
}

