/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import melonslise.locks.Locks;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class LockPickItem
extends Item {
    public static final float DEFAULT_STRENGTH = 0.3f;
    public static final String KEY_STRENGTH = "Strength";

    public LockPickItem(Item.Properties props) {
        super(props);
    }

    public static float getOrSetStrength(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b(KEY_STRENGTH)) {
            nbt.func_74776_a(KEY_STRENGTH, 0.3f);
        }
        return nbt.func_74760_g(KEY_STRENGTH);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        return (ActionResultType)Locks.PROXY.getLockables(world).map(lockables -> {
            List matching = lockables.get().values().stream().filter(LocksPredicates.LOCKED.and(lockable1 -> lockable1.box.intersects(pos))).collect(Collectors.toList());
            if (matching.isEmpty()) {
                return ActionResultType.PASS;
            }
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)ctx.func_195999_j()), (INamedContainerProvider)new LockPickingContainer.Provider(pos, (Lockable)matching.get(0)), (Consumer)new LockPickingContainer.Writer(pos, (Lockable)matching.get(0)));
            return ActionResultType.SUCCESS;
        }).orElse((Object)ActionResultType.PASS);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        LockPickItem.getOrSetStrength(stack);
        items.add((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lines, ITooltipFlag flag) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_STRENGTH)) {
            lines.add((ITextComponent)new TranslationTextComponent("locks.tooltip.strength", new Object[]{ItemStack.field_111284_a.format(LockPickItem.getOrSetStrength(stack))}).func_240699_a_(TextFormatting.DARK_GREEN));
        }
    }
}

