/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.Random;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Orientation;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public final class LocksUtil {
    public static final String KEY_X1 = "x1";
    public static final String KEY_Y1 = "y1";
    public static final String KEY_Z1 = "z1";
    public static final String KEY_X2 = "x2";
    public static final String KEY_Y2 = "y2";
    public static final String KEY_Z2 = "z2";
    public static final String KEY_ID = "id";
    public static final String KEY_LENGTH = "length";
    public static final String KEY_OLD_CODE = "code";
    public static final String KEY_OLD_COMBINATION = "combination";
    public static final String KEY_LOCKED = "locked";
    public static final String KEY_BOX = "box";
    public static final String KEY_LOCK = "lock";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OLD_SIDE = "side";

    private LocksUtil() {
    }

    public static void shuffle(byte[] array, Random rng) {
        for (int a = array.length - 1; a > 0; --a) {
            int index = rng.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static BlockPos transformPos(int x, int y, int z, PlacementSettings settings) {
        switch (settings.func_186212_b()) {
            case LEFT_RIGHT: {
                z = -z + 1;
                break;
            }
            case FRONT_BACK: {
                x = -x + 1;
                break;
            }
        }
        int x1 = settings.func_207664_d().func_177958_n();
        int z1 = settings.func_207664_d().func_177952_p();
        switch (settings.func_186215_c()) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(x1 - z1 + z, y, x1 + z1 - x + 1);
            }
            case CLOCKWISE_90: {
                return new BlockPos(x1 + z1 - z + 1, y, z1 - x1 + x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(x1 + x1 - x + 1, y, z1 + z1 - z + 1);
            }
        }
        return new BlockPos(x, y, z);
    }

    public static AttachFace faceFromDir(Direction dir) {
        return dir == Direction.UP ? AttachFace.CEILING : (dir == Direction.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
    }

    public static Cuboid6i readBoxFromNBT(CompoundNBT nbt) {
        return new Cuboid6i(nbt.func_74762_e(KEY_X1), nbt.func_74762_e(KEY_Y1), nbt.func_74762_e(KEY_Z1), nbt.func_74762_e(KEY_X2), nbt.func_74762_e(KEY_Y2), nbt.func_74762_e(KEY_Z2));
    }

    public static CompoundNBT writeBoxToNBT(Cuboid6i box) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KEY_X1, box.x1);
        nbt.func_74768_a(KEY_Y1, box.y1);
        nbt.func_74768_a(KEY_Z1, box.z1);
        nbt.func_74768_a(KEY_X2, box.x2);
        nbt.func_74768_a(KEY_Y2, box.y2);
        nbt.func_74768_a(KEY_Z2, box.z2);
        return nbt;
    }

    public static Lock readLockFromNBT(CompoundNBT nbt) {
        int id;
        int n = id = nbt.func_186855_b(KEY_ID) ? ThreadLocalRandom.current().nextInt() : nbt.func_74762_e(KEY_ID);
        int length = nbt.func_74764_b(KEY_LENGTH) ? nbt.func_74771_c(KEY_LENGTH) : (nbt.func_74764_b(KEY_OLD_CODE) ? nbt.func_74770_j(KEY_OLD_CODE).length : nbt.func_74770_j(KEY_OLD_COMBINATION).length);
        return new Lock(id, length, nbt.func_74767_n(KEY_LOCKED));
    }

    public static CompoundNBT writeLockToNBT(Lock lock) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KEY_ID, lock.id);
        nbt.func_74774_a(KEY_LENGTH, (byte)lock.combination.length);
        nbt.func_74757_a(KEY_LOCKED, lock.locked);
        return nbt;
    }

    public static Lockable readLockableFromNBT(CompoundNBT nbt) {
        Orientation orient = nbt.func_74764_b(KEY_ORIENTATION) ? Orientation.values()[nbt.func_74771_c(KEY_ORIENTATION)] : Orientation.fromDirection(Direction.func_82600_a((int)nbt.func_74771_c(KEY_OLD_SIDE)), Direction.NORTH);
        return new Lockable(LocksUtil.readBoxFromNBT(nbt.func_74775_l(KEY_BOX)), LocksUtil.readLockFromNBT(nbt.func_74775_l(KEY_LOCK)), orient);
    }

    public static CompoundNBT writeLockableToNBT(Lockable lockable) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(KEY_BOX, (INBT)LocksUtil.writeBoxToNBT(lockable.box));
        nbt.func_218657_a(KEY_LOCK, (INBT)LocksUtil.writeLockToNBT(lockable.lock));
        nbt.func_74774_a(KEY_ORIENTATION, (byte)lockable.orient.ordinal());
        return nbt;
    }

    public static Cuboid6i readBoxFromBuffer(PacketBuffer buf) {
        return new Cuboid6i(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeBoxToBuffer(PacketBuffer buf, Cuboid6i box) {
        buf.writeInt(box.x1);
        buf.writeInt(box.y1);
        buf.writeInt(box.z1);
        buf.writeInt(box.x2);
        buf.writeInt(box.y2);
        buf.writeInt(box.z2);
    }

    public static Lock readLockFromBuffer(PacketBuffer buf) {
        return new Lock(buf.readInt(), buf.readByte(), buf.readBoolean());
    }

    public static void writeLockToBuffer(PacketBuffer buf, Lock lock) {
        buf.writeInt(lock.id);
        buf.writeByte(lock.getLength());
        buf.writeBoolean(lock.isLocked());
    }

    public static Lockable readLockableFromBuffer(PacketBuffer buf) {
        return new Lockable(LocksUtil.readBoxFromBuffer(buf), LocksUtil.readLockFromBuffer(buf), (Orientation)buf.func_179257_a(Orientation.class), buf.readInt());
    }

    public static void writeLockableToBuffer(PacketBuffer buf, Lockable lockable) {
        LocksUtil.writeBoxToBuffer(buf, lockable.box);
        LocksUtil.writeLockToBuffer(buf, lockable.lock);
        buf.func_179249_a((Enum)lockable.orient);
        buf.writeInt(lockable.networkID);
    }

    public static boolean intersectsInclusive(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.field_72340_a <= box2.field_72336_d && box1.field_72336_d >= box2.field_72340_a && box1.field_72338_b <= box2.field_72337_e && box1.field_72337_e >= box2.field_72338_b && box1.field_72339_c <= box2.field_72334_f && box1.field_72334_f >= box2.field_72339_c;
    }

    public static Vector3d getAABBSideCenter(AxisAlignedBB box, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vector3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72338_b, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case UP: {
                return new Vector3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72337_e, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case NORTH: {
                return new Vector3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72339_c);
            }
            case SOUTH: {
                return new Vector3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72334_f);
            }
            case WEST: {
                return new Vector3d(box.field_72340_a, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case EAST: {
                return new Vector3d(box.field_72336_d, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
        }
        return null;
    }
}

