/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import melonslise.locks.client.init.LocksRenderTypes;
import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="locks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksClientForgeEvents {
    public static ItemStack LOCK_MODEL_STACK = null;

    private LocksClientForgeEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END || mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> lockables.get().values().forEach(lockable -> {
            if (lockable.box.loaded((World)mc.field_71441_e)) {
                lockable.tick();
            }
        }));
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo info = mc.field_71460_t.func_215316_n();
        Matrix4f proj = event.getProjectionMatrix();
        Vector3d origin = info.func_216785_c();
        IRenderTypeBuffer.Impl buf = mc.func_228019_au_().func_228487_b_();
        MatrixStack mtx = event.getMatrixStack();
        BlockPos.Mutable mutPos = new BlockPos.Mutable();
        mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (Lockable lockable : lockables.get().values()) {
                Lockable.State state = lockable.getLockState((World)mc.field_71441_e);
                if (state == null || !state.inRange(origin) || !state.inView(LocksClientUtil.getClippingHelper(mtx, proj, info))) continue;
                mtx.func_227860_a_();
                mtx.func_227861_a_(state.pos.field_72450_a - origin.field_72450_a, state.pos.field_72448_b - origin.field_72448_b, state.pos.field_72449_c - origin.field_72449_c);
                mtx.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-state.orient.dir.func_185119_l() - 180.0f));
                if (state.orient.face != AttachFace.WALL) {
                    mtx.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                mtx.func_227861_a_(0.0, 0.1, 0.0);
                mtx.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lockable.maxShakeTicks - lockable.prevShakeTicks, lockable.maxShakeTicks - lockable.shakeTicks, event.getPartialTicks()) / (float)lockable.maxShakeTicks) * (float)lockable.maxShakeTicks / 5.0f * 3.14f)) * 10.0f));
                mtx.func_227861_a_(0.0, -0.1, 0.0);
                mtx.func_227862_a_(0.5f, 0.5f, 0.5f);
                int packedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)mc.field_71441_e, (BlockPos)mutPos.func_189532_c(state.pos.field_72450_a, state.pos.field_72448_b, state.pos.field_72449_c));
                mc.func_175599_af().func_229110_a_(LOCK_MODEL_STACK, ItemCameraTransforms.TransformType.FIXED, packedLight, OverlayTexture.field_229196_a_, mtx, (IRenderTypeBuffer)buf);
                RenderSystem.disableDepthTest();
                buf.func_228461_a_();
                mtx.func_227865_b_();
            }
        });
        mc.field_71439_g.getCapability(LocksCapabilities.LOCK_SELECTION).ifPresent(select -> {
            BlockPos pos1 = select.get();
            if (pos1 == null) {
                return;
            }
            BlockPos pos2 = mc.field_71476_x instanceof BlockRayTraceResult ? ((BlockRayTraceResult)mc.field_71476_x).func_216350_a() : pos1;
            Cuboid6i box = new Cuboid6i(pos1, pos2);
            float r = 0.0f;
            float g = 0.0f;
            if (box.volume() > (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get() || !LocksServerConfig.canLock((World)mc.field_71441_e, pos2)) {
                r = 1.0f;
            } else {
                g = 1.0f;
            }
            mtx.func_227860_a_();
            WorldRenderer.func_228427_a_((MatrixStack)mtx, (IVertexBuilder)buf.getBuffer(LocksRenderTypes.OVERLAY_LINES), (double)((double)box.x1 - origin.field_72450_a), (double)((double)box.y1 - origin.field_72448_b), (double)((double)box.z1 - origin.field_72449_c), (double)((double)box.x2 - origin.field_72450_a), (double)((double)box.y2 - origin.field_72448_b), (double)((double)box.z2 - origin.field_72449_c), (float)r, (float)g, (float)0.0f, (float)0.5f);
            RenderSystem.disableDepthTest();
            buf.func_228461_a_();
            mtx.func_227865_b_();
        });
    }
}

