/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui.sprite;

import com.mojang.blaze3d.matrix.MatrixStack;
import melonslise.locks.client.gui.sprite.Sprite;
import melonslise.locks.client.gui.sprite.Texture;
import melonslise.locks.client.util.LocksClientUtil;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RotatableSprite
extends Sprite {
    public float rotation;
    public float oldRotation;
    public float motionRotation;
    public float originX;
    public float originY;
    public int ticksRotation;

    public RotatableSprite(Texture tex) {
        super(tex);
        this.originX = this.texture.width / 2;
        this.originY = this.texture.height / 2;
    }

    @Override
    public void draw(MatrixStack mtx, float x, float y, float partialTick) {
        mtx.func_227860_a_();
        mtx.func_227861_a_((double)(this.originX + this.shiftX), (double)(this.originY + this.shiftY), 0.0);
        mtx.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(LocksClientUtil.lerp(this.oldRotation, this.rotation, partialTick)));
        mtx.func_227861_a_((double)(-this.originX - this.shiftX), (double)(-this.originY - this.shiftY), 0.0);
        super.draw(mtx, x, y, partialTick);
        mtx.func_227865_b_();
    }

    @Override
    public void update() {
        super.update();
        this.rotate();
    }

    protected void rotate() {
        this.oldRotation = this.rotation;
        if (this.ticksRotation > 0) {
            this.rotation += this.motionRotation;
            --this.ticksRotation;
            if (this.ticksRotation <= 0) {
                this.motionRotation = 0.0f;
            }
        } else {
            this.rotation += this.motionRotation;
        }
    }

    public void rotate(float motion, int ticks) {
        this.motionRotation = motion;
        this.ticksRotation = ticks;
    }

    @Override
    public void reset() {
        super.reset();
        this.motionRotation = 0.0f;
        this.oldRotation = 0.0f;
        this.rotation = 0.0f;
        this.ticksRotation = 0;
    }
}

