/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class LocksClientUtil {
    private LocksClientUtil() {
    }

    public static void drawTexturedRectangle(MatrixStack mtx, float x, float y, int u, int v, int width, int height, int texWidth, int texHeight) {
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_227888_a_(last, x, y + (float)height, 0.0f).func_225583_a_((float)u * f, (float)(v + height) * f1).func_181675_d();
        buf.func_227888_a_(last, x + (float)width, y + (float)height, 0.0f).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buf.func_227888_a_(last, x + (float)width, y, 0.0f).func_225583_a_((float)(u + width) * f, (float)v * f1).func_181675_d();
        buf.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_((float)u * f, (float)v * f1).func_181675_d();
        buf.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
    }

    public static ClippingHelper getClippingHelper(MatrixStack mtx, Matrix4f proj, ActiveRenderInfo info) {
        ClippingHelper ch = Minecraft.func_71410_x().field_71438_f.field_175001_U;
        if (ch != null) {
            return ch;
        }
        ch = new ClippingHelper(mtx.func_227866_c_().func_227870_a_(), proj);
        Vector3d pos = info.func_216785_c();
        ch.func_228952_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        return ch;
    }

    public static float lerp(float start, float end, float progress) {
        return start + (end - start) * progress;
    }

    public static double lerp(double start, double end, double progress) {
        return start + (end - start) * progress;
    }

    public static float cubicBezier1d(float anchor1, float anchor2, float progress) {
        float oneMinusP = 1.0f - progress;
        return 3.0f * oneMinusP * oneMinusP * progress * anchor1 + 3.0f * oneMinusP * progress * progress * anchor2 + progress * progress * progress;
    }
}

