/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import javax.annotation.Nonnull;
import melonslise.locks.common.init.LocksItems;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class KeyRingInventory
implements IItemHandlerModifiable {
    public final int size;
    public final ItemStack stack;

    public KeyRingInventory(ItemStack stack, int rows, int col) {
        this.size = rows * col;
        this.stack = stack;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListNBT list = this.stack.func_196082_o().func_150295_c("Items", 10);
        for (int a = 0; a < list.size(); ++a) {
            CompoundNBT nbt = list.func_150305_b(a);
            if (nbt.func_74762_e("Slot") != slot) continue;
            return ItemStack.func_199557_a((CompoundNBT)nbt);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        CompoundNBT nbt = null;
        if (!stack.func_190926_b()) {
            nbt = new CompoundNBT();
            nbt.func_74768_a("Slot", slot);
            stack.func_77955_b(nbt);
        }
        ListNBT list = this.stack.func_196082_o().func_150295_c("Items", 10);
        for (int a = 0; a < list.size(); ++a) {
            CompoundNBT existing = list.func_150305_b(a);
            if (existing.func_74762_e("Slot") != slot) continue;
            if (!stack.func_190926_b()) {
                list.set(a, (INBT)nbt);
            } else {
                list.remove(a);
            }
            return;
        }
        if (!stack.func_190926_b()) {
            list.add((Object)nbt);
        }
        this.stack.func_196082_o().func_218657_a("Items", (INBT)list);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.func_77976_d();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190916_E() <= 0) {
                existing = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.setStackInSlot(slot, existing);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() == LocksItems.KEY.get();
    }
}

