/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import java.util.function.Consumer;
import melonslise.locks.client.gui.LockPickingScreen;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksContainerTypes;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.CheckPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.PacketDistributor;

public class LockPickingContainer
extends Container {
    public static final ITextComponent TITLE = new TranslationTextComponent("locks.gui.lockpicking.title");
    public PlayerEntity player;
    public BlockPos pos;
    public Lockable lockable;
    protected int currentIndex = 0;
    public static final IContainerFactory<LockPickingContainer> FACTORY = (id, inv, buffer) -> {
        BlockPos pos = buffer.func_179259_c();
        Lockable lockable = (Lockable)inv.field_70458_d.field_70170_p.getCapability(LocksCapabilities.LOCKABLES).map(lockables -> (Lockable)lockables.get().get(buffer.readInt())).orElse(null);
        return new LockPickingContainer(id, inv.field_70458_d, pos, lockable);
    };

    public LockPickingContainer(int id, PlayerEntity player, BlockPos pos, Lockable lockable) {
        super((ContainerType)LocksContainerTypes.LOCK_PICKING.get(), id);
        this.player = player;
        this.pos = pos;
        this.lockable = lockable;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean func_75145_c(PlayerEntity player) {
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_77973_b() != LocksItems.LOCK_PICK.get()) continue;
            return true;
        }
        return false;
    }

    public void checkPin(int currentPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currentIndex, currentPin)) {
            ++this.currentIndex;
            correct = true;
            this.player.field_70170_p.func_184133_a(null, this.pos, (SoundEvent)LocksSoundEvents.PIN_MATCH.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (!this.breakPick(this.player)) {
            this.player.field_70170_p.func_184133_a(null, this.pos, (SoundEvent)LocksSoundEvents.PIN_FAIL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            reset = true;
            this.reset();
        }
        LocksNetworks.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new CheckPinResultPacket(correct, reset));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof LockPickingScreen) {
            ((LockPickingScreen)screen).handlePin(correct, reset);
        }
        if (correct) {
            ++this.currentIndex;
        }
        if (reset) {
            this.reset();
        }
    }

    public boolean isOpen() {
        return this.currentIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currentIndex = 0;
    }

    protected boolean breakPick(PlayerEntity player) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = player.func_184582_a(slot);
            if (slot.func_188453_a() != EquipmentSlotType.Group.HAND || stack.func_77973_b() != LocksItems.LOCK_PICK.get()) continue;
            if (player.field_70170_p.field_73012_v.nextFloat() < LockPickItem.getOrSetStrength(stack)) {
                return false;
            }
            this.player.func_213361_c(slot);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.field_70170_p.func_184133_a(player, this.pos, (SoundEvent)LocksSoundEvents.LOCK_OPEN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static class Writer
    implements Consumer<PacketBuffer> {
        public final BlockPos pos;
        public final Lockable lockable;

        public Writer(BlockPos pos, Lockable lockable) {
            this.pos = pos;
            this.lockable = lockable;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179255_a(this.pos);
            buffer.writeInt(this.lockable.networkID);
        }
    }

    public static class Provider
    implements INamedContainerProvider {
        public final BlockPos pos;
        public final Lockable lockable;

        public Provider(BlockPos pos, Lockable lockable) {
            this.pos = pos;
            this.lockable = lockable;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
            return new LockPickingContainer(id, player, this.pos, this.lockable);
        }

        public ITextComponent func_145748_c_() {
            return TITLE;
        }
    }
}

