/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import java.util.List;
import java.util.stream.Collectors;
import melonslise.locks.common.config.LocksClientConfig;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="locks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksForgeEvents {
    public static final ITextComponent LOCKED_MESSAGE = new TranslationTextComponent("locks.status.locked");

    private LocksForgeEvents() {
    }

    @SubscribeEvent
    public static void attachCapabilitiesToWorld(AttachCapabilitiesEvent<World> event) {
        LocksCapabilities.attachToWorld(event);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToEntity(AttachCapabilitiesEvent<Entity> event) {
        LocksCapabilities.attachToEntity(event);
    }

    public static void syncLockables(World world, RegistryKey<World> dim) {
        world.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (Lockable lockable : lockables.get().values()) {
                LocksNetworks.MAIN.send(PacketDistributor.DIMENSION.with(() -> dim), (Object)new AddLockablePacket(lockable));
            }
        });
    }

    public static void syncLockables(World world) {
        LocksForgeEvents.syncLockables(world, (RegistryKey<World>)world.func_234923_W_());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LocksForgeEvents.syncLockables(event.getPlayer().field_70170_p);
    }

    @SubscribeEvent
    public static void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        LocksForgeEvents.syncLockables(event.getPlayer().field_70170_p, (RegistryKey<World>)event.getTo());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LocksForgeEvents.syncLockables(event.getPlayer().field_70170_p);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        event.player.getCapability(LocksCapabilities.LOCK_SELECTION).ifPresent(select -> {
            if (select.get() == null) {
                return;
            }
            for (ItemStack stack : event.player.func_184214_aD()) {
                if (!(stack.func_77973_b() instanceof LockItem)) continue;
                return;
            }
            select.set(null);
        });
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        world.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            List intersecting = lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(pos)).collect(Collectors.toList());
            if (intersecting.isEmpty()) {
                return;
            }
            if (event.getHand() != Hand.MAIN_HAND) {
                event.setUseBlock(Event.Result.DENY);
                return;
            }
            if (intersecting.stream().anyMatch(LocksPredicates.LOCKED)) {
                intersecting.stream().filter(LocksPredicates.LOCKED).forEach(lockable -> lockable.shake(20));
                event.setUseBlock(Event.Result.DENY);
                world.func_184133_a(player, pos, (SoundEvent)LocksSoundEvents.LOCK_RATTLE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(Hand.MAIN_HAND);
                if (world.field_72995_K && ((Boolean)LocksClientConfig.DEAF_MODE.get()).booleanValue()) {
                    player.func_146105_b(LOCKED_MESSAGE, true);
                }
                return;
            }
            if (((Boolean)LocksServerConfig.ALLOW_REMOVING_LOCKS.get()).booleanValue() && player.func_225608_bj_() && event.getItemStack().func_190926_b()) {
                List matching = intersecting.stream().filter(LocksPredicates.NOT_LOCKED).collect(Collectors.toList());
                if (matching.isEmpty()) {
                    return;
                }
                event.setUseBlock(Event.Result.DENY);
                world.func_184133_a(player, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                player.func_184609_a(Hand.MAIN_HAND);
                if (!world.field_72995_K) {
                    for (Lockable lockable2 : matching) {
                        world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, LockItem.from(lockable2.lock)));
                        lockables.remove(lockable2.networkID);
                    }
                }
            }
        });
    }

    public static boolean canBreakLockable(PlayerEntity player, BlockPos pos) {
        return (Boolean)player.field_70170_p.getCapability(LocksCapabilities.LOCKABLES).map(lockables -> (Boolean)LocksServerConfig.PROTECT_LOCKABLES.get() == false || player.func_184812_l_() || !lockables.get().values().stream().anyMatch(lockable1 -> lockable1.lock.isLocked() && lockable1.box.intersects(pos))).orElse((Object)true);
    }

    @SubscribeEvent
    public static void onBlockBreaking(PlayerEvent.BreakSpeed event) {
        if (!LocksForgeEvents.canBreakLockable(event.getPlayer(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!LocksForgeEvents.canBreakLockable(event.getPlayer(), event.getPos())) {
            event.setCanceled(true);
        }
    }
}

