/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import melonslise.locks.common.init.LocksRecipeSerializers;
import melonslise.locks.common.item.LockingItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LockingItemCloningRecipe
extends SpecialRecipe {
    public final Ingredient locking;
    public final NonNullList<Ingredient> blanks;
    public final ItemStack result;

    public LockingItemCloningRecipe(ResourceLocation id, Ingredient locking, NonNullList<Ingredient> blanks, ItemStack result) {
        super(id);
        this.locking = locking;
        this.blanks = blanks;
        this.result = result;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public boolean matches(CraftingInventory inv, World world) {
        ItemStack locking = ItemStack.field_190927_a;
        ArrayList blanks = Lists.newArrayList();
        for (int a = 0; a < inv.func_70302_i_(); ++a) {
            ItemStack stack = inv.func_70301_a(a);
            if (stack.func_190926_b()) continue;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("id") && this.locking.test(stack)) {
                locking = stack;
                continue;
            }
            blanks.add(stack);
        }
        return !locking.func_190926_b() && RecipeMatcher.findMatches((List)blanks, this.blanks) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList stacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int a = 0; a < inv.func_70302_i_(); ++a) {
            ItemStack stack = inv.func_70301_a(a);
            if (!this.locking.test(stack)) continue;
            stacks.set(a, (Object)stack.func_77946_l());
        }
        return stacks;
    }

    public ItemStack getCraftingResult(CraftingInventory inventory) {
        ItemStack locking = ItemStack.field_190927_a;
        for (int a = 0; a < inventory.func_70302_i_() && locking.func_190926_b(); ++a) {
            ItemStack stack = inventory.func_70301_a(a);
            if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("id") || !this.locking.test(stack)) continue;
            locking = stack;
        }
        return LockingItem.copyId(locking, this.result.func_77946_l());
    }

    public boolean func_194133_a(int width, int height) {
        return this.blanks.size() + 1 <= width * height;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LocksRecipeSerializers.LOCKING_ITEM_CLONING.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<LockingItemCloningRecipe> {
        public LockingItemCloningRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient locking = Ingredient.func_199802_a((JsonElement)json.get("locking"));
            NonNullList<Ingredient> blanks = Serializer.deserializeIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"blanks"));
            if (blanks.isEmpty()) {
                throw new JsonParseException("Not enough items for locking item cloning recipe");
            }
            if (blanks.size() > 8) {
                throw new JsonParseException("Too many items for locking item cloning recipe");
            }
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new LockingItemCloningRecipe(id, locking, blanks, result);
        }

        private static NonNullList<Ingredient> deserializeIngredients(JsonArray array) {
            NonNullList list = NonNullList.func_191196_a();
            for (int a = 0; a < array.size(); ++a) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)array.get(a));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        public LockingItemCloningRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient locking = Ingredient.func_199566_b((PacketBuffer)buffer);
            int size = buffer.func_150792_a();
            NonNullList blanks = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int a = 0; a < size; ++a) {
                blanks.set(a, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new LockingItemCloningRecipe(id, locking, (NonNullList<Ingredient>)blanks, result);
        }

        public void write(PacketBuffer buffer, LockingItemCloningRecipe recipe) {
            recipe.locking.func_199564_a(buffer);
            buffer.func_150787_b(recipe.blanks.size());
            for (Ingredient ingredient : recipe.blanks) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.result);
        }
    }
}

