/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicInteger;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Lockable
extends Observable
implements Observer {
    private static final AtomicInteger networkIDs = new AtomicInteger();
    public final Cuboid6i box;
    public final Lock lock;
    public final Orientation orient;
    public final int networkID;
    public Map<List<BlockState>, State> cache = new HashMap<List<BlockState>, State>();
    public int prevShakeTicks;
    public int shakeTicks;
    public int maxShakeTicks;

    public Lockable(Cuboid6i box, Lock lock, Orientation orient) {
        this(box, lock, orient, networkIDs.incrementAndGet());
    }

    public Lockable(Cuboid6i box, Lock lock, Orientation orient, int networkID) {
        this.box = box;
        this.lock = lock;
        lock.addObserver(this);
        this.orient = orient;
        this.networkID = networkID;
    }

    @Override
    public void update(Observable lock, Object data) {
        this.setChanged();
        this.notifyObservers();
    }

    public void tick() {
        this.prevShakeTicks = this.shakeTicks;
        if (this.shakeTicks > 0) {
            --this.shakeTicks;
        }
    }

    public void shake(int ticks) {
        this.prevShakeTicks = this.maxShakeTicks = ticks;
        this.shakeTicks = this.maxShakeTicks;
    }

    public State getLockState(World world) {
        Vector3d center;
        ArrayList<BlockState> states = new ArrayList<BlockState>(this.box.volume());
        for (BlockPos pos : this.box.getContainedBlockPositions()) {
            if (!world.func_175667_e(pos)) {
                return null;
            }
            states.add(world.func_180495_p(pos));
        }
        State state = this.cache.get(states);
        if (state != null) {
            return state;
        }
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>(4);
        for (BlockPos pos : this.box.getContainedBlockPositions()) {
            VoxelShape shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
            if (shape.func_197766_b()) continue;
            AxisAlignedBB box = shape.func_197752_a();
            AxisAlignedBB union = box = box.func_186670_a(pos);
            Iterator iterator = boxes.iterator();
            while (iterator.hasNext()) {
                AxisAlignedBB box1 = (AxisAlignedBB)iterator.next();
                if (!LocksUtil.intersectsInclusive(union, box1)) continue;
                union = union.func_111270_a(box1);
                iterator.remove();
            }
            boxes.add(union);
        }
        if (boxes.isEmpty()) {
            return null;
        }
        Direction side = this.orient.getCuboidFace();
        Vector3d point = center = this.box.getSideCenter(side);
        double min = -1.0;
        for (AxisAlignedBB box : boxes) {
            for (Direction side1 : Direction.values()) {
                Vector3d point1 = LocksUtil.getAABBSideCenter(box, side1).func_178787_e(Vector3d.func_237491_b_((Vector3i)side1.func_176730_m()).func_186678_a(0.05));
                double dist = center.func_72436_e(point1);
                if (min != -1.0 && dist >= min) continue;
                point = point1;
                min = dist;
                side = side1;
            }
        }
        state = new State(point, Orientation.fromDirection(side, this.orient.dir));
        this.cache.put(states, state);
        return state;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)object;
        return this.networkID == lockable.networkID && (this.box == null && lockable.box == null || this.box.equals(lockable.box)) && (this.lock == null && lockable.lock == null || this.lock.equals(lockable.lock)) && this.orient == lockable.orient;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.box, this.lock, this.orient, this.networkID});
    }

    public static class State {
        public static final AxisAlignedBB VERT_Z_BB = new AxisAlignedBB(-0.125, -0.1875, 0.03125, 0.125, 0.1875, 0.03125);
        public static final AxisAlignedBB VERT_X_BB = LocksUtil.rotateY(VERT_Z_BB);
        public static final AxisAlignedBB HOR_Z_BB = LocksUtil.rotateX(VERT_Z_BB);
        public static final AxisAlignedBB HOR_X_BB = LocksUtil.rotateY(HOR_Z_BB);
        public final Vector3d pos;
        public final Orientation orient;
        public final AxisAlignedBB bb;

        public State(Vector3d pos, Orientation orient) {
            this(pos, orient, (orient.face == AttachFace.WALL ? (orient.dir.func_176740_k() == Direction.Axis.Z ? VERT_Z_BB : VERT_X_BB) : (orient.dir.func_176740_k() == Direction.Axis.Z ? HOR_Z_BB : HOR_X_BB)).func_191194_a(pos));
        }

        public State(Vector3d pos, Orientation orient, AxisAlignedBB bounds) {
            this.pos = pos;
            this.orient = orient;
            this.bb = bounds;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean inView(ClippingHelper clippingHelper) {
            return clippingHelper.func_228953_a_(this.bb.field_72340_a, this.bb.field_72338_b, this.bb.field_72339_c, this.bb.field_72336_d, this.bb.field_72337_e, this.bb.field_72334_f);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean inRange(Vector3d pos) {
            double max;
            Minecraft mc = Minecraft.func_71410_x();
            double dist = this.pos.func_72436_e(pos);
            return dist < (max = (double)(mc.field_71474_y.field_151451_c * 8)) * max;
        }
    }
}

