/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LockableInfo;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Template.class})
public class TemplateMixin {
    private final List<LockableInfo> lockables = new ArrayList<LockableInfo>();
    private static final String KEY_LOCKABLES = "lockables";

    @Inject(at={@At(value="HEAD")}, method={"takeBlocksFromWorld(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;ZLnet/minecraft/block/Block;)V"})
    public void takeBlocksFromWorld(World world, BlockPos start, BlockPos size, boolean takeEntities, @Nullable Block toIgnore, CallbackInfo ci) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            this.lockables.clear();
            world.getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
                Cuboid6i box = new Cuboid6i(start, start.func_177982_a(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p() - 1));
                lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(box)).forEach(lockable -> {
                    Cuboid6i newBox = box.intersection(lockable.box).offset(-start.func_177958_n(), -start.func_177956_o(), -start.func_177952_p());
                    this.lockables.add(new LockableInfo(newBox, lockable.lock, lockable.orient));
                });
            });
        }
    }

    @Inject(at={@At(value="RETURN", ordinal=1)}, method={"func_237146_a_(Lnet/minecraft/world/IServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/feature/template/PlacementSettings;Ljava/util/Random;I)Z"})
    public void addBlocksToWorld(IServerWorld world, BlockPos start, BlockPos size, PlacementSettings settings, Random rand, int i, CallbackInfoReturnable<Boolean> cir) {
        world.func_201672_e().getCapability(LocksCapabilities.LOCKABLES).ifPresent(lockables -> {
            for (LockableInfo lockable : this.lockables) {
                BlockPos pos1 = LocksUtil.transformPos(lockable.box.x1, lockable.box.y1, lockable.box.z1, settings);
                BlockPos pos2 = LocksUtil.transformPos(lockable.box.x2, lockable.box.y2, lockable.box.z2, settings);
                Cuboid6i box = new Cuboid6i(pos1.func_177958_n() + start.func_177958_n(), pos1.func_177956_o() + start.func_177956_o(), pos1.func_177952_p() + start.func_177952_p(), pos2.func_177958_n() + start.func_177958_n(), pos2.func_177956_o() + start.func_177956_o(), pos2.func_177952_p() + start.func_177952_p());
                Lock lock = (Boolean)LocksConfig.RANDOMIZE_LOADED_LOCKS.get() != false ? new Lock(world.func_201674_k().nextInt(), LocksConfig.randLockLen(world.func_201674_k()), true) : lockable.lock;
                Orientation orient = Orientation.fromDirectionAndFace(settings.func_186215_c().func_185831_a(settings.func_186212_b().func_185800_a(lockable.lockOrientation.dir).func_185831_a(lockable.lockOrientation.dir)), lockable.lockOrientation.face, Direction.NORTH);
                lockables.add(new Lockable(box, lock, orient));
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"writeToNBT(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"})
    public void writeToNBT(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> cir) {
        ListNBT lockableNBTList = new ListNBT();
        for (LockableInfo lockable : this.lockables) {
            CompoundNBT lockableNBT = new CompoundNBT();
            lockableNBT.func_218657_a("box", (INBT)LocksUtil.writeBoxToNBT(lockable.box));
            lockableNBT.func_218657_a("lock", (INBT)LocksUtil.writeLockToNBT(lockable.lock));
            lockableNBT.func_74774_a("orientation", (byte)lockable.lockOrientation.ordinal());
            lockableNBTList.add((Object)lockableNBT);
        }
        nbt.func_218657_a(KEY_LOCKABLES, (INBT)lockableNBTList);
    }

    @Inject(at={@At(value="HEAD")}, method={"read(Lnet/minecraft/nbt/CompoundNBT;)V"})
    public void read(CompoundNBT nbt, CallbackInfo ci) {
        this.lockables.clear();
        ListNBT nbtList = nbt.func_150295_c(KEY_LOCKABLES, 10);
        int b = nbtList.size();
        for (int a = 0; a < b; ++a) {
            CompoundNBT lockableNBT = nbtList.func_150305_b(a);
            Cuboid6i box = LocksUtil.readBoxFromNBT(lockableNBT.func_74775_l("box"));
            Lock lock = LocksUtil.readLockFromNBT(lockableNBT.func_74775_l("lock"));
            Orientation orient = Orientation.values()[lockableNBT.func_74771_c("orientation")];
            this.lockables.add(new LockableInfo(box, lock, orient));
        }
    }
}

