/*
 * Decompiled with CFR 0.152.
 */
package com.github.trhod177.lootbagmod;

import com.github.trhod177.lootbagmod.CommonProxy;
import com.github.trhod177.lootbagmod.ItemBasicRewardBag;
import com.github.trhod177.lootbagmod.LootBagConfig;
import com.github.trhod177.lootbagmod.LootBagDropsConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="lootbagmod", version="1.5", name="Loot Bag Mod", acceptedMinecraftVersions="[1.12.2]")
public class LootBagMod {
    public static final String MODID = "lootbagmod";
    public static final String VERSION = "1.5";
    public static final String NAME = "Loot Bag Mod";
    @Mod.Instance
    public static LootBagMod instance;
    @SidedProxy(clientSide="com.github.trhod177.lootbagmod.ClientProxy", serverSide="com.github.trhod177.lootbagmod.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        LootTables.registerTables();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        System.out.println("LootBagMod: Starting whitelist2");
        if (!LootBagConfig.enablewhitelist) {
            for (Object item : Item.field_150901_e) {
                String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)item))).toString();
                ItemBasicRewardBag.Droppables.add(name.toString());
            }
            ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(LootBagConfig.Blacklist));
            ItemBasicRewardBag.Droppables.removeAll(stringList);
            if (LootBagConfig.debugmode) {
                System.out.println(ItemBasicRewardBag.Droppables);
                LootBagMod.listItems();
                LootBagMod.blackListItems();
            }
        } else if (LootBagConfig.enablewhitelist) {
            String[] whitelist = LootBagConfig.whitelist;
            for (int i = 0; i < whitelist.length; ++i) {
                String name = LootBagConfig.whitelist[i];
                System.out.println(name.toString());
                ItemBasicRewardBag.DroppablesWhiteList.add(name.toString());
            }
        }
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-droppableitems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            Iterator<String> iterator = ItemBasicRewardBag.Droppables.iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = iterator.next();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file droppableitems.txt");
            e.printStackTrace();
        }
    }

    public static void blackListItems() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-blacklisteditems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            String[] stringArray = LootBagConfig.Blacklist;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item;
                String name = item = stringArray[i];
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file blacklisteditems.txt");
            e.printStackTrace();
        }
    }

    @Mod.EventBusSubscriber(modid="lootbagmod")
    static class LootTables {
        LootTables() {
        }

        public static void registerTables() {
            LootTables.registerTable("desert_pyramid");
            LootTables.registerTable("abandoned_mineshaft");
            LootTables.registerTable("end_city_treasure");
            LootTables.registerTable("jungle_temple");
            LootTables.registerTable("simple_dungeon");
            LootTables.registerTable("stronghold_corridor");
            LootTables.registerTable("stronghold_crossing");
            LootTables.registerTable("stronghold_library");
            LootTables.registerTable2("blaze");
            LootTables.registerTable2("creeper");
            LootTables.registerTable2("elder_guardian");
            LootTables.registerTable2("endermite");
            LootTables.registerTable2("evoker");
            LootTables.registerTable2("ghast");
            LootTables.registerTable2("guardian");
            LootTables.registerTable2("husk");
            LootTables.registerTable2("magma_cube");
            LootTables.registerTable2("shulker");
            LootTables.registerTable2("silverfish");
            LootTables.registerTable2("skeleton");
            LootTables.registerTable2("slime");
            LootTables.registerTable2("stray");
            LootTables.registerTable2("vindicator");
            LootTables.registerTable2("witch");
            LootTables.registerTable2("wither_skeleton");
            LootTables.registerTable2("zombie");
            LootTables.registerTable2("zombie_villager");
            LootTables.registerTable2("cave_spider");
            LootTables.registerTable2("spider");
            LootTables.registerTable2("zombie_pigman");
            LootTables.registerTable2("enderman");
        }

        @SubscribeEvent
        public static void onEvent(LootTableLoadEvent event) {
            LootTable table = event.getTable();
            String tableName = event.getName().toString();
            if (tableName.equals("minecraft:chests/desert_pyramid")) {
                table.addPool(LootTables.newPoolEntry("desert_pyramid"));
            }
            if (tableName.equals("minecraft:chests/abandoned_mineshaft")) {
                table.addPool(LootTables.newPoolEntry("abandoned_mineshaft"));
            }
            if (tableName.equals("minecraft:chests/end_city_treasure")) {
                table.addPool(LootTables.newPoolEntry("end_city_treasure"));
            }
            if (tableName.equals("minecraft:chests/jungle_temple")) {
                table.addPool(LootTables.newPoolEntry("jungle_temple"));
            }
            if (tableName.equals("minecraft:chests/simple_dungeon")) {
                table.addPool(LootTables.newPoolEntry("simple_dungeon"));
            }
            if (tableName.equals("minecraft:chests/stronghold_corridor")) {
                table.addPool(LootTables.newPoolEntry("stronghold_corridor"));
            }
            if (tableName.equals("minecraft:chests/stronghold_crossing")) {
                table.addPool(LootTables.newPoolEntry("stronghold_crossing"));
            }
            if (tableName.equals("minecraft:chests/stronghold_library")) {
                table.addPool(LootTables.newPoolEntry("stronghold_library"));
            }
            if (tableName.equals("minecraft:entities/blaze") && LootBagDropsConfig.blaze) {
                table.addPool(LootTables.newPoolEntry2("blaze"));
                System.out.println("Blaze loot table loaded");
            }
            if (tableName.equals("minecraft:entities/creeper") && LootBagDropsConfig.creeper) {
                table.addPool(LootTables.newPoolEntry2("creeper"));
                System.out.println("Creeper loot table loaded");
            }
            if (tableName.equals("minecraft:entities/elder_guardian") && LootBagDropsConfig.elder_guardian) {
                table.addPool(LootTables.newPoolEntry2("elder_guardian"));
                System.out.println("Elder_guardian loot table loaded");
            }
            if (tableName.equals("minecraft:entities/endermite") && LootBagDropsConfig.endermite) {
                table.addPool(LootTables.newPoolEntry2("endermite"));
                System.out.println("Endermite loot table loaded");
            }
            if (tableName.equals("minecraft:entities/evoker") && LootBagDropsConfig.evoker) {
                table.addPool(LootTables.newPoolEntry2("evoker"));
                System.out.println("Evoker loot table loaded");
            }
            if (tableName.equals("minecraft:entities/ghast") && LootBagDropsConfig.ghast) {
                table.addPool(LootTables.newPoolEntry2("ghast"));
                System.out.println("Ghast loot table loaded");
            }
            if (tableName.equals("minecraft:entities/guardian") && LootBagDropsConfig.guardian) {
                table.addPool(LootTables.newPoolEntry2("guardian"));
                System.out.println("Guardian loot table loaded");
            }
            if (tableName.equals("minecraft:entities/husk") && LootBagDropsConfig.husk) {
                table.addPool(LootTables.newPoolEntry2("husk"));
                System.out.println("Husk loot table loaded");
            }
            if (tableName.equals("minecraft:entities/magma_cube") && LootBagDropsConfig.magma_cube) {
                table.addPool(LootTables.newPoolEntry2("magma_cube"));
                System.out.println("Magma_cube loot table loaded");
            }
            if (tableName.equals("minecraft:entities/shulker") && LootBagDropsConfig.shulker) {
                table.addPool(LootTables.newPoolEntry2("shulker"));
                System.out.println("Shulker loot table loaded");
            }
            if (tableName.equals("minecraft:entities/silverfish") && LootBagDropsConfig.silverfish) {
                table.addPool(LootTables.newPoolEntry2("silverfish"));
                System.out.println("Silverfish loot table loaded");
            }
            if (tableName.equals("minecraft:entities/skeleton") && LootBagDropsConfig.skeleton) {
                table.addPool(LootTables.newPoolEntry2("skeleton"));
                System.out.println("Skeleton loot table loaded");
            }
            if (tableName.equals("minecraft:entities/slime") && LootBagDropsConfig.slime) {
                table.addPool(LootTables.newPoolEntry2("slime"));
                System.out.println("Slime loot table loaded");
            }
            if (tableName.equals("minecraft:entities/stray") && LootBagDropsConfig.stray) {
                table.addPool(LootTables.newPoolEntry2("stray"));
                System.out.println("Stray loot table loaded");
            }
            if (tableName.equals("minecraft:entities/vindicator") && LootBagDropsConfig.vindicator) {
                table.addPool(LootTables.newPoolEntry2("vindicator"));
                System.out.println("Vindicator loot table loaded");
            }
            if (tableName.equals("minecraft:entities/witch") && LootBagDropsConfig.witch) {
                table.addPool(LootTables.newPoolEntry2("witch"));
                System.out.println("Witch loot table loaded");
            }
            if (tableName.equals("minecraft:entities/wither_skeleton") && LootBagDropsConfig.wither_skeleton) {
                table.addPool(LootTables.newPoolEntry2("wither_skeleton"));
                System.out.println("Wither_skeleton loot table loaded");
            }
            if (tableName.equals("minecraft:entities/zombie") && LootBagDropsConfig.zombie) {
                table.addPool(LootTables.newPoolEntry2("zombie"));
                System.out.println("Zombie loot table loaded");
            }
            if (tableName.equals("minecraft:entities/zombie_villager") && LootBagDropsConfig.zombie_villager) {
                table.addPool(LootTables.newPoolEntry2("zombie_villager"));
                System.out.println("Zombie_villager loot table loaded");
            }
            if (tableName.equals("minecraft:entities/cave_spider") && LootBagDropsConfig.cave_spider) {
                table.addPool(LootTables.newPoolEntry2("cave_spider"));
                System.out.println("Cave_spider loot table loaded");
            }
            if (tableName.equals("minecraft:entities/spider") && LootBagDropsConfig.spider) {
                table.addPool(LootTables.newPoolEntry2("spider"));
                System.out.println("Spider loot table loaded");
            }
            if (tableName.equals("minecraft:entities/zombie_pigman") && LootBagDropsConfig.zombie_pigman) {
                table.addPool(LootTables.newPoolEntry2("zombie_pigman"));
                System.out.println("Zombie_pigman loot table loaded");
            }
            if (tableName.equals("minecraft:entities/enderman") && LootBagDropsConfig.enderman) {
                table.addPool(LootTables.newPoolEntry2("enderman"));
                System.out.println("Enderman loot table loaded");
            }
        }

        public static void registerTable(String name) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(LootBagMod.MODID, "inject/" + name));
        }

        public static void registerTable2(String name) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(LootBagMod.MODID, "inject/mobs/" + name));
        }

        public static LootPool newPoolEntry(String name) {
            return new LootPool(new LootEntry[]{new LootEntryTable(new ResourceLocation(LootBagMod.MODID, "inject/" + name), 1, 0, new LootCondition[0], LootBagMod.MODID)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), LootBagMod.MODID);
        }

        public static LootPool newPoolEntry2(String name) {
            return new LootPool(new LootEntry[]{new LootEntryTable(new ResourceLocation(LootBagMod.MODID, "inject/mobs/" + name), 1, 0, new LootCondition[0], LootBagMod.MODID)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), LootBagMod.MODID);
        }
    }
}

