/*
 * Decompiled with CFR 0.152.
 */
package com.github.trhod177.lootbagmod;

import com.github.trhod177.lootbagmod.ConfigManager;
import com.github.trhod177.lootbagmod.EventHandlerNew;
import com.github.trhod177.lootbagmod.ItemBasicRewardBag;
import com.github.trhod177.lootbagmod.LootBagConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lootbagmod")
public class LootBagMod {
    public static LootBagMod instance;
    public static final String Version = "1.5.3";
    public static final String MODID = "lootbagmod";
    public static final Logger logger;

    public LootBagMod() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigManager.CLIENT, "lootbagmod-client.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ConfigManager.loadConfig(ConfigManager.CLIENT, FMLPaths.CONFIGDIR.get().resolve("lootbagmod-client.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerNew());
        if (!((Boolean)LootBagConfig.enablewhitelist.get()).booleanValue()) {
            for (Object item : ForgeRegistries.ITEMS) {
                String name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)item)).toString();
                ItemBasicRewardBag.Droppables.add(name);
            }
            ArrayList stringList = new ArrayList((Collection)LootBagConfig.BlackList.get());
            ItemBasicRewardBag.Droppables.removeAll(stringList);
        } else if (((Boolean)LootBagConfig.enablewhitelist.get()).booleanValue()) {
            ArrayList whitelist = new ArrayList((Collection)LootBagConfig.WhiteList.get());
            for (int i = 0; i < whitelist.size(); ++i) {
                String name = (String)((List)LootBagConfig.WhiteList.get()).get(i);
                ItemBasicRewardBag.DroppablesWhiteList.add(name.toString());
            }
        }
        if (((Boolean)LootBagConfig.debugmode.get()).booleanValue()) {
            System.out.println(ItemBasicRewardBag.Droppables);
            LootBagMod.listItems();
            LootBagMod.blackListItems();
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-droppableitems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            Iterator<String> iterator = ItemBasicRewardBag.Droppables.iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = iterator.next();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file droppableitems.txt");
            e.printStackTrace();
        }
    }

    public static void blackListItems() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-blacklisteditems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            Iterator iterator = ((List)LootBagConfig.BlackList.get()).iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = (String)iterator.next();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file blacklisteditems.txt");
            e.printStackTrace();
        }
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static Item lootbag;

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{lootbag = (Item)new ItemBasicRewardBag(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(RegistryEvents.location("lootbag"))});
        }

        private static ResourceLocation location(String name) {
            return new ResourceLocation(LootBagMod.MODID, name);
        }
    }
}

