/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LumberjackConfig {
    public static final General GENERAL;
    static final ForgeConfigSpec spec;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(General::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
    }

    public static class General {
        public ForgeConfigSpec.BooleanValue leaves;
        public ForgeConfigSpec.IntValue totalLimit;
        public ForgeConfigSpec.IntValue tickLimit;
        public ForgeConfigSpec.IntValue mode;
        public ForgeConfigSpec.DoubleValue damageMultiplier;
        public ForgeConfigSpec.DoubleValue speed;
        public ForgeConfigSpec.DoubleValue durabilityMultiplier;

        General(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("General");
            this.totalLimit = builder.comment("Hard limit of the amount that can be broken in one go.").translation("lumberjack.config.totalLimit").defineInRange("totalLimit", 1024, 1, Integer.MAX_VALUE);
            this.tickLimit = builder.comment("Hard limit of the amount that can be broken in one go.").translation("lumberjack.config.tickLimit").defineInRange("tickLimit", 32, 1, Integer.MAX_VALUE);
            this.mode = builder.comment("Valid modes:0: Only chop blocks with the same blockid1: Chop all wooden blocks").translation("lumberjack.config.mode").defineInRange("mode", 0, 0, 1);
            this.leaves = builder.comment("Harvest leaves too.").translation("lumberjack.config.leaves").define("leaves", false);
            this.damageMultiplier = builder.comment("Multiplier used for attack damage. Tool material * this value = axe damage").translation("lumberjack.config.damageMultiplier").defineInRange("damageMultiplier", 3.2, 0.0, 2.147483647E9);
            this.durabilityMultiplier = builder.comment("Multiplier used for durability. Tool material * this value = axe durability").translation("lumberjack.config.durabilityMultiplier").defineInRange("durabilityMultiplier", 1.5, 0.0, 2.147483647E9);
            this.speed = builder.comment("Speed used for attack speed. 4 - this value = axe speed").translation("lumberjack.config.speed").defineInRange("speed", -3.3, -3.9, 0.0);
        }
    }
}

