/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection;

import com.google.common.collect.Lists;
import com.tomboshoven.minecraft.magicmirror.MagicMirrorMod;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifier;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Reflection {
    static int activeReflectionsClient;
    final List<ReflectionModifier> modifiers = Lists.newArrayList();
    @Nullable
    Entity reflectedEntity;
    float angle;

    public static int getActiveReflectionsClient() {
        return activeReflectionsClient;
    }

    public void stopReflecting() {
        if (this.reflectedEntity != null) {
            MagicMirrorMod.LOGGER.debug("No longer reflecting {}", (Object)this.reflectedEntity.func_200200_C_());
            this.cleanUpRenderer();
            this.reflectedEntity = null;
            this.decrementActiveReflections();
        }
    }

    void incrementActiveClientReflections() {
    }

    void decrementActiveReflections() {
    }

    void buildFrameBuffer() {
    }

    void cleanUpFrameBuffer() {
    }

    void rebuildRenderer() {
    }

    void cleanUpRenderer() {
    }

    @Nullable
    public Entity getReflectedEntity() {
        return this.reflectedEntity;
    }

    public void setReflectedEntity(Entity reflectedEntity) {
        if (this.reflectedEntity != reflectedEntity) {
            MagicMirrorMod.LOGGER.debug("Reflecting {}", (Object)reflectedEntity.func_200200_C_());
            if (this.reflectedEntity == null) {
                this.incrementActiveClientReflections();
            }
            this.reflectedEntity = reflectedEntity;
            this.rebuildRenderer();
        }
    }

    public void addModifier(ReflectionModifier modifier) {
        this.modifiers.add(modifier);
        this.rebuildRenderer();
    }

    public void removeModifier(ReflectionModifier modifier) {
        this.modifiers.remove(modifier);
        this.rebuildRenderer();
    }

    public void render(float partialTicks) {
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

