/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers.ReflectionRendererModifier;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BannerReflectionRendererModifier
extends ReflectionRendererModifier {
    private static final double BACKGROUND_DISTANCE = 16.0;
    private static final float BANNER_TEXTURE_START_U = 0.0f;
    private static final float BANNER_TEXTURE_END_U = 5.5f;
    private static final float BANNER_TEXTURE_START_V = 0.0f;
    private static final float BANNER_TEXTURE_END_V = 10.25f;
    private final ImmutableList<Pair<BannerPattern, DyeColor>> patternColorList;

    public BannerReflectionRendererModifier(ReflectionRendererBase baseRenderer, Collection<Pair<BannerPattern, DyeColor>> patternColorList) {
        super(baseRenderer);
        this.patternColorList = ImmutableList.copyOf(patternColorList);
    }

    @Override
    public void render(float facing, float partialTicks, IRenderTypeBuffer renderTypeBuffer) {
        super.render(facing, partialTicks, renderTypeBuffer);
        for (Pair patternColor : this.patternColorList) {
            float[] rgb = ((DyeColor)patternColor.getRight()).func_193349_f();
            RenderMaterial material = new RenderMaterial(Atlases.field_228744_c_, ((BannerPattern)patternColor.getLeft()).func_226957_a_(true));
            IVertexBuilder buffer = material.func_229311_a_(renderTypeBuffer, RenderType::func_228650_h_);
            TextureAtlasSprite sprite = material.func_229314_c_();
            buffer.func_225582_a_(-8.0, -16.0, -16.0).func_227885_a_(rgb[0], rgb[1], rgb[2], 1.0f).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(0.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(8.0, -16.0, -16.0).func_227885_a_(rgb[0], rgb[1], rgb[2], 1.0f).func_225583_a_(sprite.func_94214_a(5.5), sprite.func_94207_b(0.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(8.0, 16.0, -16.0).func_227885_a_(rgb[0], rgb[1], rgb[2], 1.0f).func_225583_a_(sprite.func_94214_a(5.5), sprite.func_94207_b(10.25)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-8.0, 16.0, -16.0).func_227885_a_(rgb[0], rgb[1], rgb[2], 1.0f).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(10.25)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        }
    }
}

