/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.modifiers;

import com.google.common.collect.Maps;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MagicMirrorModifier {
    private static final Map<String, MagicMirrorModifier> MODIFIERS = Maps.newHashMap();

    public static void register(MagicMirrorModifier modifier) {
        MODIFIERS.putIfAbsent(modifier.getName(), modifier);
    }

    public static Collection<MagicMirrorModifier> getModifiers() {
        return Collections.unmodifiableCollection(MODIFIERS.values());
    }

    @Nullable
    public static MagicMirrorModifier getModifier(String name) {
        return MODIFIERS.get(name);
    }

    @Nullable
    private static MagicMirrorBaseTileEntity getMagicMirrorTileEntity(IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof MagicMirrorBaseTileEntity) {
            return (MagicMirrorBaseTileEntity)tileEntity;
        }
        return null;
    }

    private static boolean hasModifierOfType(IBlockReader world, BlockPos pos, MagicMirrorModifier modifier) {
        MagicMirrorBaseTileEntity magicMirrorTileEntity = MagicMirrorModifier.getMagicMirrorTileEntity(world, pos);
        if (magicMirrorTileEntity == null) {
            return false;
        }
        return magicMirrorTileEntity.getModifiers().stream().anyMatch(teModifier -> teModifier.getModifier() == modifier);
    }

    public abstract String getName();

    public abstract boolean canModify(World var1, BlockPos var2, ItemStack var3);

    public void apply(IBlockReader worldIn, BlockPos pos, ItemStack heldItem) {
        MagicMirrorBaseTileEntity magicMirrorTileEntity = MagicMirrorModifier.getMagicMirrorTileEntity(worldIn, pos);
        if (magicMirrorTileEntity == null) {
            return;
        }
        this.apply(magicMirrorTileEntity, heldItem);
    }

    private void apply(MagicMirrorBaseTileEntity tileEntity, ItemStack heldItem) {
        tileEntity.addModifier(this.createTileEntityModifier(heldItem));
        heldItem.func_190918_g(1);
    }

    public void apply(MagicMirrorBaseTileEntity tileEntity, CompoundNBT nbt) {
        MagicMirrorTileEntityModifier magicMirrorTileEntityModifier = this.createTileEntityModifier(nbt);
        tileEntity.addModifier(magicMirrorTileEntityModifier);
    }

    abstract MagicMirrorTileEntityModifier createTileEntityModifier(CompoundNBT var1);

    abstract MagicMirrorTileEntityModifier createTileEntityModifier(ItemStack var1);

    boolean hasModifierOfType(IBlockReader world, BlockPos pos) {
        return MagicMirrorModifier.hasModifierOfType(world, pos, this);
    }
}

