/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.gui.IDrawGuiCallback;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.client.render.RenderUtil;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class DrawScreenHelper {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    public static final int ZERO_ALPHA = new Color(255, 255, 255, 0).getRGB();
    public final BlockPos pos;
    public final Direction facing;
    public final BlockState state;
    public final IBakedModel model;
    public final LinkedList<PictureState> statesForUndo = new LinkedList();
    public final LinkedList<PictureState> statesForRedo = new LinkedList();
    public final boolean hadPaint;
    private final IDrawGuiCallback callback;
    public Color color = Color.BLACK;
    public int toolSize = 1;
    private PictureState paintingState;
    private PictureState currentState;
    private boolean clickStartedInPicture = false;
    private EnumDrawType activeDrawType = EnumDrawType.PENCIL;
    private boolean hasSizeWindow;
    private boolean noRevert = false;
    private boolean updating = false;

    public DrawScreenHelper(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, Direction facing, BlockState state, IDrawGuiCallback callback) {
        this.callback = callback;
        Objects.requireNonNull(canvas, "Canvas is null");
        Preconditions.checkArgument((boolean)canvas.hasPaintData(), (Object)"No data in canvas");
        this.pos = pos;
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        this.currentState = new PictureState(canvas);
        for (IPaintable paint : prevImages) {
            this.statesForUndo.add(new PictureState(paint));
        }
        this.hadPaint = true;
    }

    protected DrawScreenHelper(byte scaleFactor, BlockPos pos, Direction facing, BlockState state, IDrawGuiCallback callback) {
        int[][] picture;
        this.pos = Objects.requireNonNull(pos);
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        this.callback = callback;
        for (int[] tileArray : picture = new int[128 / scaleFactor][128 / scaleFactor]) {
            Arrays.fill(tileArray, ZERO_ALPHA);
        }
        this.currentState = new PictureState(picture, scaleFactor);
        this.hadPaint = false;
    }

    private void init() {
        this.hasSizeWindow = false;
    }

    public void saveImage() {
        try {
            this.saveImage(true);
        }
        catch (IOException e) {
            MCPaint.LOGGER.error("Could not save image!", (Throwable)e);
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Failed to save file!"), true);
            minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Failed to save file!"), false);
        }
    }

    public void rotateRight() {
        int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            int[] yData = this.currentState.picture[x];
            for (int y = 0; y < yData.length; ++y) {
                newData[yData.length - y - 1][x] = yData[y];
            }
        }
        this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
    }

    public void rotateLeft() {
        int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            int[] yData = this.currentState.picture[x];
            for (int y = 0; y < yData.length; ++y) {
                newData[y][this.currentState.picture.length - x - 1] = yData[y];
            }
        }
        this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
    }

    public void saveAndClose() {
        Minecraft mc = Minecraft.func_71410_x();
        if (Arrays.stream(this.currentState.picture).anyMatch(ints -> Arrays.stream(ints).anyMatch(value -> value != ZERO_ALPHA))) {
            this.noRevert = true;
            MCPaintUtil.uploadPictureToServer(mc.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, false);
        } else if (this.hadPaint) {
            MCPaintUtil.uploadPictureToServer(mc.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, true);
        }
        mc.func_147108_a(null);
    }

    public void onClose() {
        if (!this.noRevert) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageDrawAbort(this.pos));
        }
    }

    public void renderBackgroundBlock(MatrixStack stack, int startLeft, int startTop) {
        Minecraft mc = Minecraft.func_71410_x();
        List quads = this.model.getQuads(this.state, this.facing.func_176734_d(), new Random(), (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad quad : quads) {
            TextureAtlasSprite sprite = quad.func_187508_a();
            RenderSystem.pushMatrix();
            mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            if (quad.func_178212_b()) {
                int color = mc.func_184125_al().func_228054_a_(this.state, (IBlockDisplayReader)mc.field_71441_e, this.pos, quad.func_178211_c());
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                RenderSystem.color3f((float)red, (float)green, (float)blue);
            }
            AbstractGui.func_238470_a_((MatrixStack)stack, (int)startLeft, (int)startTop, (int)-1, (int)128, (int)128, (TextureAtlasSprite)sprite);
            RenderSystem.popMatrix();
        }
    }

    public void renderImage(MatrixStack stack, int startLeft, int startTop, int[][] toDraw) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtil.renderInGui(stack.func_227866_c_().func_227870_a_(), startLeft, startTop, this.currentState.scaleFactor, buffer, toDraw);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void switchToolButton(EnumDrawType newDrawType) {
        this.activeDrawType = newDrawType;
        this.hasSizeWindow = this.activeDrawType.hasSizeRegulator;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.handleMouse(mouseX, mouseY, mouseButton)) {
            this.clickStartedInPicture = true;
            return true;
        }
        return false;
    }

    public boolean handleMouseDragged(double mouseX, double mouseY, int mouseButton) {
        return this.clickStartedInPicture && this.handleMouse(mouseX, mouseY, mouseButton);
    }

    public void handleMouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.clickStartedInPicture = false;
        if (this.paintingState != null) {
            this.newPictureState(this.paintingState);
            this.paintingState = null;
        }
    }

    private void newPictureState(PictureState state) {
        if (state.isSame(this.currentState)) {
            return;
        }
        this.statesForRedo.clear();
        this.statesForUndo.add(this.currentState);
        this.currentState = state;
        if (this.statesForUndo.size() > 20) {
            this.statesForUndo.removeFirst();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    public void undo() {
        if (this.statesForUndo.size() > 0) {
            this.statesForRedo.add(this.currentState);
            this.currentState = this.statesForUndo.removeLast();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    public void redo() {
        if (this.statesForRedo.size() > 0) {
            this.statesForUndo.add(this.currentState);
            this.currentState = this.statesForRedo.removeLast();
        }
        this.callback.updateUndoRedoButton(!this.statesForUndo.isEmpty(), !this.statesForRedo.isEmpty());
    }

    private boolean handleMouse(double mouseXD, double mouseYD, int mouseButton) {
        int offsetMouseY;
        if (mouseButton != 0) {
            return false;
        }
        int mouseX = (int)Math.round(mouseXD);
        int mouseY = (int)Math.round(mouseYD);
        int offsetMouseX = this.callback.offsetMouseX(mouseX);
        if (this.callback.isInPicture(offsetMouseX, offsetMouseY = this.callback.offsetMouseY(mouseY))) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            if (this.paintingState == null) {
                this.paintingState = new PictureState(this.currentState);
            }
            if (pixelPosX < this.paintingState.picture.length && pixelPosY < this.paintingState.picture.length && this.color != null) {
                this.color = this.activeDrawType.draw(this.paintingState.picture, this.color, pixelPosX, pixelPosY, this.toolSize);
                this.callback.updateSliders();
                return true;
            }
        }
        return false;
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
        ResourceLocation resourcelocation = p_184396_1_.func_195668_m();
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("textures/%s%s", resourcelocation.func_110623_a(), ".png"));
    }

    private void saveImage(boolean background) throws IOException {
        Minecraft minecraft = Minecraft.func_71410_x();
        BufferedImage paint = new BufferedImage(128 / this.currentState.scaleFactor, 128 / this.currentState.scaleFactor, 2);
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            for (int y = 0; y < this.currentState.picture[0].length; ++y) {
                paint.setRGB(x, y, this.currentState.picture[x][y]);
            }
        }
        BufferedImage output = new BufferedImage(paint.getWidth(), paint.getHeight(), 2);
        if (background) {
            List quads = this.model.getQuads(this.state, this.facing.func_176734_d(), new Random(), (IModelData)EmptyModelData.INSTANCE);
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.func_187508_a();
                IResource resource = minecraft.func_195551_G().func_199002_a(this.getResourceLocation(sprite));
                Throwable throwable = null;
                try {
                    Image image = ImageIO.read(resource.func_199027_b());
                    if (quad.func_178212_b()) {
                        int color = minecraft.func_184125_al().func_228054_a_(this.state, (IBlockDisplayReader)minecraft.field_71441_e, this.pos, quad.func_178211_c());
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        Image asBufferedImage = image;
                        for (int x = 0; x < ((BufferedImage)asBufferedImage).getWidth(); ++x) {
                            for (int y = 0; y < ((BufferedImage)asBufferedImage).getHeight(); ++y) {
                                Color originalColor = new Color(((BufferedImage)asBufferedImage).getRGB(x, y), true);
                                int newRed = Math.round((float)originalColor.getRed() * red);
                                int newGreen = Math.round((float)originalColor.getGreen() * green);
                                int newBlue = Math.round((float)originalColor.getBlue() * blue);
                                ((BufferedImage)asBufferedImage).setRGB(x, y, new Color(newRed, newGreen, newBlue, originalColor.getAlpha()).getRGB());
                            }
                        }
                    }
                    image = image.getScaledInstance(output.getWidth(), output.getHeight(), 2);
                    output.getGraphics().drawImage(image, 0, 0, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
        }
        output.getGraphics().drawImage(paint, 0, 0, null);
        File file = new File(minecraft.field_71412_D, "paintings");
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create folder");
        }
        File finalFile = DrawScreenHelper.getTimestampedPNGFileForDirectory(file);
        if (!ImageIO.write((RenderedImage)output, "png", finalFile)) {
            throw new IOException("Could not encode image as png!");
        }
        StringTextComponent component = new StringTextComponent(finalFile.getName());
        component = component.func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalFile.getAbsolutePath())));
        minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("mcpaint.gui.saved", new Object[]{component}), false);
    }

    private static File getTimestampedPNGFileForDirectory(File gameDirectory) {
        String s = DATE_FORMAT.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public EnumDrawType activeDrawType() {
        return this.activeDrawType;
    }

    public boolean hasSizeWindow() {
        return this.hasSizeWindow;
    }

    public PictureState currentState() {
        return this.currentState;
    }

    public int[][] getBasePicture() {
        return this.paintingState == null ? this.currentState.picture : this.paintingState.picture;
    }
}

