/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui.drawutil;

import ichttt.mods.mcpaint.client.gui.DrawScreenHelper;
import ichttt.mods.mcpaint.client.gui.drawutil.FillImpl;
import java.awt.Color;
import javax.annotation.Nonnull;

public enum EnumDrawType {
    PENCIL(true){

        @Override
        @Nonnull
        public Color draw(int[][] picture, Color color, int pixelX, int pixelY, int size) {
            1.drawInSize(picture, color.getRGB(), pixelX, pixelY, size);
            return color;
        }
    }
    ,
    FILL(false){

        @Override
        @Nonnull
        public Color draw(int[][] picture, Color color, int pixelX, int pixelY, int size) {
            int originalColor = picture[pixelX][pixelY];
            int colorRGB = color.getRGB();
            if (originalColor == colorRGB) {
                return color;
            }
            FillImpl.floodFillImage(picture, pixelX, pixelY, colorRGB);
            return color;
        }
    }
    ,
    ERASER(true){

        @Override
        @Nonnull
        public Color draw(int[][] picture, Color color, int pixelX, int pixelY, int size) {
            3.drawInSize(picture, DrawScreenHelper.ZERO_ALPHA, pixelX, pixelY, size);
            return color;
        }
    }
    ,
    PICK_COLOR(false){

        @Override
        @Nonnull
        public Color draw(int[][] picture, Color color, int pixelX, int pixelY, int size) {
            return new Color(picture[pixelX][pixelY], true);
        }
    };

    public final boolean hasSizeRegulator;

    static void drawInSize(int[][] picture, int color, int pixelX, int pixelY, int size) {
        if (size == 1) {
            picture[pixelX][pixelY] = color;
        } else {
            int minPixelX = Math.max(0, pixelX - --size);
            int maxPixelX = Math.min(picture.length - 1, pixelX + size);
            int minPixelY = Math.max(0, pixelY - size);
            int maxPixelY = Math.min(picture.length - 1, pixelY + size);
            for (int x = 0; x <= maxPixelX - minPixelX; ++x) {
                for (int y = 0; y <= maxPixelY - minPixelY; ++y) {
                    picture[minPixelX + x][minPixelY + y] = color;
                }
            }
        }
    }

    @Nonnull
    public abstract Color draw(int[][] var1, Color var2, int var3, int var4, int var5);

    private EnumDrawType(boolean hasSizeRegulator) {
        this.hasSizeRegulator = hasSizeRegulator;
    }
}

