/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderUtil {
    public static void renderInGui(Matrix4f matrix4f, float leftOffset, float topOffset, byte scaleFactor, BufferBuilder builder, int[][] picture) {
        int light = LightTexture.func_228451_a_((int)15, (int)15);
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                float left = leftOffset + (float)(x * scaleFactor);
                float top = topOffset + (float)(y * scaleFactor);
                float right = left + (float)scaleFactor;
                float bottom = top + (float)scaleFactor;
                RenderUtil.drawToBuffer(matrix4f, color, (IVertexBuilder)builder, left, top, right, bottom, light);
            }
        }
    }

    public static void renderInGame(Matrix4f matrix4f, byte scaleFactor, IVertexBuilder builder, int[][] picture, int light) {
        for (int x = 0; x < picture.length; ++x) {
            int[] yPos = picture[x];
            for (int y = 0; y < yPos.length; ++y) {
                int color = picture[x][y];
                float left = (float)(x * scaleFactor) / 128.0f + (float)scaleFactor / 128.0f;
                float top = 1.0f - (float)(y * scaleFactor) / 128.0f - (float)scaleFactor / 128.0f;
                float right = left - (float)scaleFactor / 128.0f;
                float bottom = top + (float)scaleFactor / 128.0f;
                RenderUtil.drawToBuffer(matrix4f, color, builder, left, top, right, bottom, light);
            }
        }
    }

    public static boolean drawToBuffer(Matrix4f matrix4f, int color, IVertexBuilder builder, float left, float top, float right, float bottom, int light) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a <= 0.01f) {
            return true;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix4f, left, bottom, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, right, bottom, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, right, top, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(matrix4f, left, top, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(light).func_181675_d();
        return false;
    }
}

